/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.people;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.model.RestPersonModel;
import org.alfresco.rest.model.RestPersonModelsCollection;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetPeopleFullTests
extends RestTest {
    UserModel userModel;
    SiteModel siteModel;
    UserModel searchedUser;
    UserModel managerUser;
    UserModel adminUser;
    private RestPersonModel personModel;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userModel = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.searchedUser = this.dataUser.createRandomTestUser();
        this.managerUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(this.managerUser, this.siteModel, UserRole.SiteManager);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify entry details for get person response with Rest API")
    public void checkResponseSchemaForGetPerson() throws Exception {
        RestPersonModel newUser = RestPersonModel.getRandomPersonModel((String[])new String[]{"aspectNames", "avatarId", "statusUpdatedAt", "displayName", "quota", "quotaUsed"});
        newUser = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingAuthUser().createPerson(newUser);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.personModel = this.restClient.authenticateUser(this.userModel).withCoreAPI().usingUser(new UserModel(newUser.getId(), newUser.getPassword())).getPerson();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPersonModel)((RestPersonModel)((RestPersonModel)((RestPersonModel)((RestPersonModel)((RestPersonModel)((RestPersonModel)((RestPersonModel)((RestPersonModel)((RestPersonModel)((RestPersonModel)((RestPersonModel)((RestPersonModel)((RestPersonModel)this.personModel.assertThat().field("id").is((Object)newUser.getId())).and().field("firstName").is((Object)newUser.getFirstName())).and().field("lastName").is((Object)newUser.getLastName())).and().field("description").is((Object)newUser.getDescription())).and().field("email").is((Object)newUser.getEmail())).and().field("skypeId").is((Object)newUser.getSkypeId())).and().field("googleId").is((Object)newUser.getGoogleId())).and().field("instantMessageId").is((Object)newUser.getInstantMessageId())).and().field("jobTitle").is((Object)newUser.getJobTitle())).and().field("location").is((Object)newUser.getLocation())).and().field("mobile").is((Object)newUser.getMobile())).and().field("telephone").is((Object)newUser.getTelephone())).and().field("userStatus").is((Object)newUser.getUserStatus())).and().field("enabled").is((Object)newUser.getEnabled())).and().field("emailNotificationsEnabled").is((Object)newUser.getEmailNotificationsEnabled());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets a person with empty personId with Rest API and response is successful")
    public void userGetPersonWithEmptyPersonId() throws Exception {
        this.restClient.authenticateUser(this.managerUser).withCoreAPI();
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)"people/{personId}?{parameters}", (String[])new String[]{"", this.restClient.getParameters()});
        RestPersonModelsCollection persons = (RestPersonModelsCollection)this.restClient.processModels(RestPersonModelsCollection.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        persons.assertThat().entriesListIsNotEmpty();
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets admin user with Rest API and response is successful")
    public void managerUserGetAdminPerson() throws Exception {
        this.personModel = this.restClient.authenticateUser(this.managerUser).withCoreAPI().usingUser(this.adminUser).getPerson();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPersonModel)((RestPersonModel)((RestPersonModel)((RestPersonModel)this.personModel.assertThat().field("id").is((Object)this.adminUser.getUsername())).and().field("firstName").is((Object)"Administrator")).and().field("email").is((Object)"admin@alfresco.com")).and().field("emailNotificationsEnabled").is((Object)"true")).and().field("enabled").is((Object)"true");
    }
}

