/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.repo.resource.content;

import java.util.Map;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestTagModel;
import org.alfresco.rest.repo.resource.Files;
import org.alfresco.rest.repo.resource.content.MultiContentCreator;
import org.alfresco.rest.repo.resource.general.ContentModifier;
import org.alfresco.rest.repo.resource.general.Creator;
import org.alfresco.rest.repo.resource.general.Modifier;
import org.alfresco.rest.repo.resource.general.Specifier;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;

public class RepoFolderModifier
extends ContentModifier<FolderModel, Modifier.FolderModifier>
implements Modifier.FolderModifier {
    private final RestWrapper restClient;
    private final DataContent dataContent;
    private final Files files;
    private final Map<String, FolderModel> foldersCache;

    public RepoFolderModifier(DataContent dataContent, RestWrapper restClient, FolderModel folder, Files files, Map<String, FolderModel> foldersCache) {
        super(dataContent, restClient, folder);
        this.dataContent = dataContent;
        this.restClient = restClient;
        this.files = files;
        this.foldersCache = foldersCache;
    }

    @Override
    protected Modifier.FolderModifier self() {
        return this;
    }

    @Override
    public Specifier.MultiContentSpecifier add() {
        return (Specifier.MultiContentSpecifier)((Creator.FolderCreator)((Creator.FolderCreator)new MultiContentCreator(this.dataContent, this.restClient, this.files, this.foldersCache).underFolder((FolderModel)this.contentModel)).withinSite(this.site)).asUser(this.user);
    }

    @Override
    public Specifier.AssociationSpecifier remove() {
        return new Specifier.AssociationSpecifier(){

            public void secondaryContent(ContentModel content) {
                RepoFolderModifier.this.buildNodeRestRequest(RepoFolderModifier.this.restClient, (RepoTestModel)RepoFolderModifier.this.contentModel).removeSecondaryChild((RepoTestModel)content);
            }

            public void tag(RestTagModel tag) {
                RepoFolderModifier.this.buildNodeRestRequest(RepoFolderModifier.this.restClient, (RepoTestModel)RepoFolderModifier.this.contentModel).deleteTag(tag);
            }
        };
    }

    @Override
    public FolderModel get(String id) {
        return super.get(id, FolderModel::new);
    }

    @Override
    public FolderModel copyTo(FolderModel target) {
        return super.copyTo(target, FolderModel::new);
    }

    @Override
    public void delete() {
        this.foldersCache.remove(((FolderModel)this.contentModel).getName());
        super.delete();
    }
}

