/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.people;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestSiteMemberModelsCollection;
import org.alfresco.utility.Utility;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DeleteSiteMemberFullTests
extends RestTest {
    private SiteModel publicSiteModel;
    private SiteModel moderatedSiteModel;
    private SiteModel privateSiteModel;
    private UserModel adminUserModel;
    private DataUser.ListUserWithRoles usersWithRolesPublicSite;
    private DataUser.ListUserWithRoles usersWithRolesModeratedSite;
    private DataUser.ListUserWithRoles usersWithRolesPrivateSite;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUserModel = this.dataUser.getAdminUser();
        this.adminUserModel.setUserRole(UserRole.SiteManager);
        this.publicSiteModel = ((DataSite)this.dataSite.usingUser(this.adminUserModel)).createPublicRandomSite();
        this.moderatedSiteModel = ((DataSite)this.dataSite.usingUser(this.adminUserModel)).createModeratedRandomSite();
        this.privateSiteModel = ((DataSite)this.dataSite.usingUser(this.adminUserModel)).createPrivateRandomSite();
        this.usersWithRolesPublicSite = this.dataUser.addUsersWithRolesToSite(this.publicSiteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
        this.usersWithRolesModeratedSite = this.dataUser.addUsersWithRolesToSite(this.moderatedSiteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
        this.usersWithRolesPrivateSite = this.dataUser.addUsersWithRolesToSite(this.privateSiteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is able to remove collaborator member of a public site")
    public void adminIsAbleToRemoveCollaboratorSiteMembershipFromPublicSite() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(this.usersWithRolesPublicSite.getOneUserWithRole(UserRole.SiteCollaborator)).deleteSiteMember(this.publicSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.publicSiteModel).addPerson(this.usersWithRolesPublicSite.getOneUserWithRole(UserRole.SiteCollaborator));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is able to remove contributor member of a public site")
    public void adminIsAbleToRemoveContributorSiteMembershipFromPublicSite() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(this.usersWithRolesPublicSite.getOneUserWithRole(UserRole.SiteContributor)).deleteSiteMember(this.publicSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.publicSiteModel).addPerson(this.usersWithRolesPublicSite.getOneUserWithRole(UserRole.SiteContributor));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to remove contributor member of a public site and response is 422")
    public void userIsNotAbleToRemoveContributorSiteMembershipFromPublicSite() throws Exception {
        this.restClient.authenticateUser(this.usersWithRolesPublicSite.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingUser(this.usersWithRolesPublicSite.getOneUserWithRole(UserRole.SiteContributor)).deleteSiteMember(this.publicSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsSummary(String.format(RestErrorModel.NOT_SUFFICIENT_PERMISSIONS, this.publicSiteModel.getId()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to remove consumer member of a public site and response is 422")
    public void userIsNotAbleToRemoveConsumerSiteMembershipFromPublicSite() throws Exception {
        this.restClient.authenticateUser(this.usersWithRolesPublicSite.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingUser(this.usersWithRolesPublicSite.getOneUserWithRole(UserRole.SiteConsumer)).deleteSiteMember(this.publicSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsSummary(String.format(RestErrorModel.NOT_SUFFICIENT_PERMISSIONS, this.publicSiteModel.getId()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is able to remove collaborator member of a moderated site")
    public void adminIsAbleToRemoveCollaboratorSiteMembershipFromModeratedSite() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(this.usersWithRolesModeratedSite.getOneUserWithRole(UserRole.SiteCollaborator)).deleteSiteMember(this.moderatedSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.moderatedSiteModel).addPerson(this.usersWithRolesModeratedSite.getOneUserWithRole(UserRole.SiteCollaborator));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is able to remove contributor member of a moderated site")
    public void adminIsAbleToRemoveContributorSiteMembershipFromModeratedSite() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(this.usersWithRolesModeratedSite.getOneUserWithRole(UserRole.SiteContributor)).deleteSiteMember(this.moderatedSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.moderatedSiteModel).addPerson(this.usersWithRolesModeratedSite.getOneUserWithRole(UserRole.SiteContributor));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to remove contributor member of a moderated site and response is 422")
    public void userIsNotAbleToRemoveContributorSiteMembershipFromModeratedSite() throws Exception {
        this.restClient.authenticateUser(this.usersWithRolesModeratedSite.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingUser(this.usersWithRolesModeratedSite.getOneUserWithRole(UserRole.SiteContributor)).deleteSiteMember(this.moderatedSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsSummary(String.format(RestErrorModel.NOT_SUFFICIENT_PERMISSIONS, this.moderatedSiteModel.getId()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to remove consumer member of a moderated site and response is 422")
    public void userIsNotAbleToRemoveConsumerSiteMembershipFromModeratedSite() throws Exception {
        this.restClient.authenticateUser(this.usersWithRolesModeratedSite.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingUser(this.usersWithRolesModeratedSite.getOneUserWithRole(UserRole.SiteConsumer)).deleteSiteMember(this.moderatedSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsSummary(String.format(RestErrorModel.NOT_SUFFICIENT_PERMISSIONS, this.moderatedSiteModel.getId()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is able to remove collaborator member of a private site")
    public void adminIsAbleToRemoveCollaboratorSiteMembershipFromPrivateSite() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(this.usersWithRolesPrivateSite.getOneUserWithRole(UserRole.SiteCollaborator)).deleteSiteMember(this.privateSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.privateSiteModel).addPerson(this.usersWithRolesPrivateSite.getOneUserWithRole(UserRole.SiteCollaborator));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is able to remove contributor member of a private site")
    public void adminIsAbleToRemoveContributorSiteMembershipFromPrivateSite() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(this.usersWithRolesPrivateSite.getOneUserWithRole(UserRole.SiteContributor)).deleteSiteMember(this.privateSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.privateSiteModel).addPerson(this.usersWithRolesPrivateSite.getOneUserWithRole(UserRole.SiteContributor));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to remove contributor member of a private site and response is 422")
    public void userIsNotAbleToRemoveContributorSiteMembershipFromPrivateSite() throws Exception {
        this.restClient.authenticateUser(this.usersWithRolesPrivateSite.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingUser(this.usersWithRolesPrivateSite.getOneUserWithRole(UserRole.SiteContributor)).deleteSiteMember(this.privateSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsSummary(String.format(RestErrorModel.NOT_SUFFICIENT_PERMISSIONS, this.privateSiteModel.getId()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to remove consumer member of a private site and response is 422")
    public void userIsNotAbleToRemoveConsumerSiteMembershipFromPrivateSite() throws Exception {
        this.restClient.authenticateUser(this.usersWithRolesPrivateSite.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingUser(this.usersWithRolesPrivateSite.getOneUserWithRole(UserRole.SiteConsumer)).deleteSiteMember(this.privateSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsSummary(String.format(RestErrorModel.NOT_SUFFICIENT_PERMISSIONS, this.privateSiteModel.getId()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is not able to remove same user twice and response is 400")
    @Bug(id="ACE-5447")
    public void adminIsNotAbleToRemoveSameUserTwice() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(this.usersWithRolesPublicSite.getOneUserWithRole(UserRole.SiteCollaborator)).deleteSiteMember(this.publicSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(this.usersWithRolesPublicSite.getOneUserWithRole(UserRole.SiteCollaborator)).deleteSiteMember(this.publicSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(RestErrorModel.ENTITY_NOT_FOUND);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.publicSiteModel).addPerson(this.usersWithRolesPublicSite.getOneUserWithRole(UserRole.SiteCollaborator));
        Utility.sleep((int)300, (int)30000, () -> ((RestSiteMemberModelsCollection)((RestModels)this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteMembers().assertThat().entriesListContains("id", this.usersWithRolesPublicSite.getOneUserWithRole(UserRole.SiteCollaborator).getUsername())).when()).getSiteMember(this.usersWithRolesPublicSite.getOneUserWithRole(UserRole.SiteCollaborator).getUsername()).assertSiteMemberHasRole(UserRole.SiteCollaborator));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify single manager is not able to delete himself and response is 400")
    public void lastManagerIsNotAbleToDeleteHimself() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(this.usersWithRolesPublicSite.getOneUserWithRole(UserRole.SiteManager)).deleteSiteMember(this.publicSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingUser(this.adminUserModel).deleteSiteMember(this.publicSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.DELETE_LAST_MANAGER, this.publicSiteModel.getTitle())).containsErrorKey(String.format(RestErrorModel.DELETE_LAST_MANAGER, this.publicSiteModel.getTitle())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
        this.restClient.withCoreAPI().usingSite(this.publicSiteModel).addPerson(this.usersWithRolesPublicSite.getOneUserWithRole(UserRole.SiteManager));
        Utility.sleep((int)300, (int)30000, () -> this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteMembers().assertThat().entriesListContains("id", this.usersWithRolesPublicSite.getOneUserWithRole(UserRole.SiteManager).getUsername()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify site creator can be deleted")
    public void siteCreatorCanBeDeleted() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(this.adminUserModel).deleteSiteMember(this.publicSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.authenticateUser(this.usersWithRolesPublicSite.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingSite(this.publicSiteModel).addPerson(this.adminUserModel);
        Utility.sleep((int)300, (int)30000, () -> this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteMembers().assertThat().entriesListContains("id", this.adminUserModel.getUsername()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is not able to remove from site a user that created a member request that was not accepted yet")
    @Bug(id="ACE-5447")
    public void adminIsNotAbleToRemoveFromSiteANonExistingMember() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(newMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSiteModel);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(newMember).deleteSiteMember(this.moderatedSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.ENTITY_NOT_FOUND);
    }
}

