/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rules;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.alfresco.rest.model.RestRuleModel;
import org.alfresco.rest.model.RestRuleSetModel;
import org.alfresco.rest.requests.Node;
import org.alfresco.rest.rules.RulesRestTest;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"rules"})
public class ReorderRulesTests
extends RulesRestTest {
    private UserModel user;
    private SiteModel site;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() {
        Step.STEP((String)"Create a user and site.");
        this.user = this.dataUser.createRandomTestUser();
        this.site = ((DataSite)this.dataSite.usingUser(this.user)).createPublicRandomSite();
    }

    @Test(groups={"rest-api", "rules"})
    public void getOrderedRuleIds() {
        Step.STEP((String)"Create a folder containing three rules in the existing site");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        List<RestRuleModel> rules = this.createRulesInFolder(folder, this.user);
        Step.STEP((String)"Get the default rule set for the folder including the ordered rule ids");
        RestRuleSetModel ruleSet = ((Node)this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folder).include(new String[]{"ruleIds"})).getDefaultRuleSet();
        List expectedRuleIds = rules.stream().map(RestRuleModel::getId).collect(Collectors.toList());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ruleSet.assertThat().field("ruleIds").is(expectedRuleIds);
    }

    @Test
    public void getRuleSetAndRuleIdsWithReadOnlyPermission() {
        Step.STEP((String)"Create a site owned by admin and add user as a consumer");
        SiteModel siteModel = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        this.dataUser.addUserToSite(this.user, siteModel, UserRole.SiteConsumer);
        Step.STEP((String)"Use admin to create a folder with a rule set and three rules in it");
        FolderModel ruleFolder = ((DataContent)this.dataContent.usingAdmin().usingSite(siteModel)).createFolder();
        ((DataContent)this.dataContent.usingAdmin().usingResource((ContentModel)ruleFolder)).createFolder();
        List<RestRuleModel> rules = this.createRulesInFolder(ruleFolder, this.dataUser.getAdminUser());
        Step.STEP((String)"Get the rule set with the ordered list of rules");
        RestRuleSetModel ruleSet = ((Node)this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)ruleFolder).include(new String[]{"ruleIds"})).getDefaultRuleSet();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        List ruleIds = rules.stream().map(RestRuleModel::getId).collect(Collectors.toList());
        ruleSet.assertThat().field("ruleIds").is(ruleIds);
    }

    @Test(groups={"rest-api", "rules"})
    public void reorderRules() {
        Step.STEP((String)"Create a folder containing three rules in the existing site");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        List<RestRuleModel> rules = this.createRulesInFolder(folder, this.user);
        Step.STEP((String)"Reverse the order of the rules within the rule set");
        List reversedRuleIds = Lists.reverse(rules.stream().map(RestRuleModel::getId).collect(Collectors.toList()));
        RestRuleSetModel ruleSetBody = new RestRuleSetModel();
        ruleSetBody.setId("-default-");
        ruleSetBody.setRuleIds(reversedRuleIds);
        RestRuleSetModel ruleSet = ((Node)this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folder).include(new String[]{"ruleIds"})).updateRuleSet(ruleSetBody);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ruleSet.assertThat().field("ruleIds").is((Object)reversedRuleIds);
    }

    @Test(groups={"rest-api", "rules"})
    public void reorderRulesUsingResponseFromGET() {
        Step.STEP((String)"Create a folder containing three rules in the existing site");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        List<RestRuleModel> rules = this.createRulesInFolder(folder, this.user);
        Step.STEP((String)"Get the rule set with its id.");
        RestRuleSetModel ruleSetResponse = ((Node)this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folder).include(new String[]{"ruleIds"})).getDefaultRuleSet();
        Step.STEP((String)"Reverse the order of the rules within the rule set");
        ruleSetResponse.setRuleIds(Lists.reverse((List)ruleSetResponse.getRuleIds()));
        RestRuleSetModel ruleSet = ((Node)this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folder).include(new String[]{"ruleIds"})).updateRuleSet(ruleSetResponse);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        List reversedRuleIds = Lists.reverse(rules.stream().map(RestRuleModel::getId).collect(Collectors.toList()));
        ruleSet.assertThat().field("ruleIds").is((Object)reversedRuleIds);
    }

    @Test
    public void reorderRulesWithoutPermission() {
        Step.STEP((String)"Create a site owned by admin and add user as a consumer");
        SiteModel siteModel = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        this.dataUser.addUserToSite(this.user, siteModel, UserRole.SiteContributor);
        Step.STEP((String)"Use admin to create a folder with a rule set and three rules in it");
        FolderModel ruleFolder = ((DataContent)this.dataContent.usingAdmin().usingSite(siteModel)).createFolder();
        ((DataContent)this.dataContent.usingAdmin().usingResource((ContentModel)ruleFolder)).createFolder();
        List<RestRuleModel> rules = this.createRulesInFolder(ruleFolder, this.dataUser.getAdminUser());
        Step.STEP((String)"Try to reorder the rules as the contributor");
        List reversedRuleIds = Lists.reverse(rules.stream().map(RestRuleModel::getId).collect(Collectors.toList()));
        RestRuleSetModel ruleSetBody = new RestRuleSetModel();
        ruleSetBody.setId("-default-");
        ruleSetBody.setRuleIds(reversedRuleIds);
        ((Node)this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)ruleFolder).include(new String[]{"ruleIds"})).updateRuleSet(ruleSetBody);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
    }

    @Test
    public void reorderRulesWithPermission() {
        Step.STEP((String)"Create a site owned by admin and add user as a collaborator");
        SiteModel siteModel = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        this.dataUser.addUserToSite(this.user, siteModel, UserRole.SiteCollaborator);
        Step.STEP((String)"Use admin to create a folder with a rule set and three rules in it");
        FolderModel ruleFolder = ((DataContent)this.dataContent.usingAdmin().usingSite(siteModel)).createFolder();
        ((DataContent)this.dataContent.usingAdmin().usingResource((ContentModel)ruleFolder)).createFolder();
        List<RestRuleModel> rules = this.createRulesInFolder(ruleFolder, this.dataUser.getAdminUser());
        Step.STEP((String)"Try to reorder the rules as the contributor");
        List reversedRuleIds = Lists.reverse(rules.stream().map(RestRuleModel::getId).collect(Collectors.toList()));
        RestRuleSetModel ruleSetBody = new RestRuleSetModel();
        ruleSetBody.setId("-default-");
        ruleSetBody.setRuleIds(reversedRuleIds);
        RestRuleSetModel ruleSet = ((Node)this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)ruleFolder).include(new String[]{"ruleIds"})).updateRuleSet(ruleSetBody);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ruleSet.assertThat().field("ruleIds").is((Object)reversedRuleIds);
    }

    private List<RestRuleModel> createRulesInFolder(FolderModel folder, UserModel user) {
        return IntStream.range(0, 3).mapToObj(index -> {
            RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
            return this.restClient.authenticateUser(user).withPrivateAPI().usingNode((RepoTestModel)folder).usingDefaultRuleSet().createSingleRule(ruleModel);
        }).collect(Collectors.toList());
    }
}

