/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.groups;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.util.UUID;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestGroupMember;
import org.alfresco.rest.model.RestGroupsModel;
import org.alfresco.rest.requests.coreAPI.RestCoreAPI;
import org.alfresco.utility.RetryOperation;
import org.alfresco.utility.Utility;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"require-solr"})
public class GroupsTests
extends RestTest {
    private UserModel adminUser;
    private UserModel userModel;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userModel = this.dataUser.createRandomTestUser();
    }

    @Test(groups={"rest-api", "groups", "sanity"})
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY}, description="Verify creation, listing, updating and deletion of groups.")
    public void createListUpdateAndDeleteGroup() {
        String groupName = "ZtestGroup" + String.valueOf(UUID.randomUUID());
        String subGroupName = "ZtestSubgroup" + String.valueOf(UUID.randomUUID());
        String groupDescription = "ZtestGroup description" + String.valueOf(UUID.randomUUID());
        JsonObject groupBody = Json.createObjectBuilder().add("id", groupName).add("displayName", groupName).add("description", groupDescription).build();
        JsonObject subgroupBody = Json.createObjectBuilder().add("id", subGroupName).add("displayName", subGroupName).build();
        String groupBodyCreate = groupBody.toString();
        String subgroupBodyCreate = subgroupBody.toString();
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingGroups().createGroup(groupBodyCreate);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
        ((RestGroupsModel)((RestGroupsModel)((RestGroupsModel)((RestGroupsModel)((RestCoreAPI)this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingParams(new String[]{"include=zones,hasSubgroups,description"})).usingGroups().createGroup(groupBodyCreate).assertThat().field("zones").contains("APP.DEFAULT")).and().field("isRoot").is((Object)true)).and().field("displayName").is((Object)groupName)).and().field("description").is((Object)groupDescription)).and().field("hasSubgroups").is((Object)false);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestCoreAPI)this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingParams(new String[]{"include=zones"})).usingGroups().createGroup(subgroupBodyCreate);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        JsonObject groupMembershipGroupBody = Json.createObjectBuilder().add("id", "GROUP_" + subGroupName).add("memberType", "GROUP").build();
        String groupMembershipGroupBodyCreate = groupMembershipGroupBody.toString();
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingGroups().createGroupMembership("GROUP_" + groupName, groupMembershipGroupBodyCreate);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestModels)((RestModels)((RestModels)((RestCoreAPI)this.restClient.withCoreAPI().usingParams(new String[]{"orderBy=displayName DESC&maxItems=10"})).usingGroups().listGroups().assertThat().entriesListContains("id", "GROUP_" + groupName)).and().entriesListContains("id", "GROUP_" + subGroupName)).and().entriesListDoesNotContain("zones")).and().paginationField("maxItems").is("10");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        groupBody = Json.createObjectBuilder().add("displayName", "Z" + groupName).add("description", "Z" + groupDescription).build();
        String groupBodyUpdate = groupBody.toString();
        ((RestGroupsModel)((RestGroupsModel)((RestGroupsModel)((RestCoreAPI)this.restClient.withCoreAPI().usingParams(new String[]{"include=description"})).usingGroups().updateGroupDetails("GROUP_" + groupName, groupBodyUpdate).assertThat().field("displayName").is((Object)("Z" + groupName))).and().field("description").is((Object)("Z" + groupDescription))).and().field("id").is((Object)("GROUP_" + groupName))).and().field("zones").isNull();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestGroupsModel)((RestGroupsModel)((RestGroupsModel)((RestCoreAPI)this.restClient.withCoreAPI().usingParams(new String[]{"include=zones,hasSubgroups"})).usingGroups().getGroupDetail("GROUP_" + groupName).assertThat().field("id").is((Object)("GROUP_" + groupName))).and().field("zones").contains("APP.DEFAULT")).and().field("isRoot").is((Object)true)).and().field("hasSubgroups").is((Object)true);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingGroups().deleteGroup("GROUP_" + subGroupName);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        ((RestGroupsModel)((RestCoreAPI)this.restClient.withCoreAPI().usingParams(new String[]{"include=zones,hasSubgroups"})).usingGroups().getGroupDetail("GROUP_" + groupName).assertThat().field("id").is((Object)("GROUP_" + groupName))).and().field("hasSubgroups").is((Object)false);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingGroups().deleteGroup("GROUP_" + groupName);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingGroups().deleteGroup("GROUP_" + groupName);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @Test(groups={"rest-api", "groups", "sanity"})
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY}, description="Verify creation, listing(only for person) and deletion of group memberships. ")
    public void createListDeleteGroupMembership() {
        String groupName = "ZtestGroup" + String.valueOf(UUID.randomUUID());
        JsonObject groupBody = Json.createObjectBuilder().add("id", groupName).add("displayName", groupName).build();
        String groupBodyCreate = groupBody.toString();
        ((RestCoreAPI)this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingParams(new String[]{"include=zones"})).usingGroups().createGroup(groupBodyCreate);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        JsonObject groupMembershipBody = Json.createObjectBuilder().add("id", this.userModel.getUsername()).add("memberType", "PERSON").build();
        String groupMembershipBodyCreate = groupMembershipBody.toString();
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingGroups().createGroupMembership("GROUP_" + groupName, groupMembershipBodyCreate);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingGroups().createGroupMembership("GROUP_" + groupName, groupMembershipBodyCreate);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingUser(this.userModel).listGroupMemberships().assertThat().entriesListContains("id", "GROUP_" + groupName);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restClient.withCoreAPI().usingGroups().deleteGroupMembership("GROUP_" + groupName, this.userModel.getUsername());
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingGroups().deleteGroupMembership("GROUP_" + groupName, this.userModel.getUsername());
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingUser(this.userModel).listGroupMemberships().assertThat().entriesListDoesNotContain("id", "GROUP_" + groupName);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "groups", "sanity"})
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY}, description="Verify listing of group memberships.")
    public void listGroupMembership() throws Exception {
        String groupName = "testGroup" + String.valueOf(UUID.randomUUID());
        JsonObject groupBody = Json.createObjectBuilder().add("id", groupName).add("displayName", groupName).build();
        String groupBodyCreate = groupBody.toString();
        ((RestCoreAPI)this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingParams(new String[]{"include=zones"})).usingGroups().createGroup(groupBodyCreate);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        JsonObject groupMembershipBody = Json.createObjectBuilder().add("id", this.userModel.getUsername()).add("memberType", "PERSON").build();
        String groupMembershipBodyCreate = groupMembershipBody.toString();
        ((RestGroupMember)((RestGroupMember)this.restClient.withCoreAPI().usingGroups().createGroupMembership("GROUP_" + groupName, groupMembershipBodyCreate).assertThat().field("displayName").is((Object)this.userModel.getUsername())).and().field("id").is((Object)this.userModel.getUsername())).and().field("memberType").is((Object)"PERSON");
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RetryOperation op = () -> {
            this.restClient.withCoreAPI().usingGroups().listGroupMemberships("GROUP_" + groupName).assertThat().entriesListContains("id", this.userModel.getUsername());
            this.restClient.assertStatusCodeIs(HttpStatus.OK);
        };
        Utility.sleep((int)500, (int)35000, (RetryOperation)op);
    }
}

