/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.queries;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestNodeModelsCollection;
import org.alfresco.rest.model.RestPersonModelsCollection;
import org.alfresco.rest.model.RestSiteModel;
import org.alfresco.rest.model.RestSiteModelsCollection;
import org.alfresco.rest.requests.Queries;
import org.alfresco.utility.RetryOperation;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.Test;

public class QueriesTest
extends RestTest {
    @TestRail(section={"rest-api", "queries"}, executionType={ExecutionType.SANITY}, description="Check basic functionality of GET queries/sites")
    @Test(groups={"rest-api", "ratings", "core"})
    public void getQueriesSites() throws Exception {
        this.restClient.authenticateUser(this.dataContent.getAdminUser()).withCoreAPI().usingQueries().findSites();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsErrorKey("Query 'term' not specified").containsSummary("Query 'term' not specified");
        ((Queries)this.restClient.withCoreAPI().usingQueries().usingParams(new String[]{"term=b"})).findSites();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsErrorKey("Query 'term' is too short");
        SiteModel site = RestSiteModel.getRandomSiteModel();
        final RestSiteModel createdSite = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingSite(site).createSite();
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RetryOperation op = new RetryOperation(){

            public void execute() throws Exception {
                RestSiteModelsCollection restSiteModels = ((Queries)QueriesTest.this.restClient.withCoreAPI().usingQueries().usingParams(new String[]{"term=" + createdSite.getTitle()})).findSites();
                Assert.assertEquals((int)restSiteModels.getEntries().size(), (int)1);
            }
        };
        Utility.sleep((int)300, (int)100000, (RetryOperation)op);
    }

    @TestRail(section={"rest-api", "queries"}, executionType={ExecutionType.SANITY}, description="Check basic functionality of GET queries/people")
    @Test(groups={"rest-api", "ratings", "core"})
    public void getQueriesPeople() throws Exception {
        this.restClient.authenticateUser(this.dataContent.getAdminUser()).withCoreAPI().usingQueries().findPeople();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsErrorKey("Query 'term' not specified").containsSummary("Query 'term' not specified");
        ((Queries)this.restClient.withCoreAPI().usingQueries().usingParams(new String[]{"term=b"})).findPeople();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsErrorKey("Query 'term' is too short");
        final UserModel userModel = this.dataUser.createRandomTestUser();
        RetryOperation op = new RetryOperation(){

            public void execute() throws Exception {
                RestPersonModelsCollection restPersonModels = ((Queries)QueriesTest.this.restClient.withCoreAPI().usingQueries().usingParams(new String[]{"term=" + userModel.getUsername()})).findPeople();
                Assert.assertEquals((int)restPersonModels.getEntries().size(), (int)1);
            }
        };
        Utility.sleep((int)300, (int)100000, (RetryOperation)op);
    }

    @TestRail(section={"rest-api", "queries"}, executionType={ExecutionType.REGRESSION}, description="Check basic functionality of GET queries/nodes")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void getOnQueriesNodesRoute() throws Exception {
        this.restClient.authenticateUser(this.dataContent.getAdminUser()).withCoreAPI().usingQueries().findNodes();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsErrorKey("Query 'term' not specified").containsSummary("Query 'term' not specified");
        ((Queries)this.restClient.withCoreAPI().usingQueries().usingParams(new String[]{"term=ab"})).findNodes();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsErrorKey("Query 'term' is too short");
        ((Queries)this.restClient.withCoreAPI().usingQueries().usingParams(new String[]{"term=name"})).findNodes();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Bug(id="REPO-4784")
    @TestRail(section={"rest-api", "queries"}, executionType={ExecutionType.REGRESSION}, description="Verify GET queries on queries/nodes return success status code")
    @Test(groups={"rest-api", "ratings", "core"})
    public void testSearchTermWhiteSpace() throws Exception {
        UserModel userModel = this.dataUser.createRandomTestUser();
        SiteModel siteModel = ((DataSite)this.dataSite.usingUser(userModel)).createPublicRandomSite();
        this.restClient.authenticateUser(userModel).withCoreAPI().usingNode((RepoTestModel)ContentModel.my()).defineNodes();
        FolderModel folder = new FolderModel("folder" + Math.random());
        final String childTerm = "find" + Math.random();
        final String childTermWS = childTerm + " find";
        ((DataContent)this.dataContent.usingUser(userModel).usingSite(siteModel)).createFolder(folder);
        FileModel file1 = new FileModel(childTerm + ".txt", FileType.TEXT_PLAIN, childTerm);
        FileModel file2 = new FileModel(childTermWS + ".txt", FileType.TEXT_PLAIN, childTermWS);
        ContentModel cm = new ContentModel();
        cm.setCmisLocation(folder.getCmisLocation());
        cm.setName(folder.getName());
        ((DataContent)((DataContent)this.dataContent.usingUser(userModel).usingSite(siteModel)).usingResource(cm)).createContent(file1);
        ((DataContent)((DataContent)this.dataContent.usingUser(userModel).usingSite(siteModel)).usingResource(cm)).createContent(file2);
        RetryOperation op = new RetryOperation(){

            public void execute() throws Exception {
                RestNodeModelsCollection nodesChildTerm = ((Queries)QueriesTest.this.restClient.withCoreAPI().usingQueries().usingParams(new String[]{"term=" + childTerm})).findNodes();
                Assert.assertEquals((int)2, (int)nodesChildTerm.getEntries().size());
                RestNodeModelsCollection nodesChildTermWS = ((Queries)QueriesTest.this.restClient.withCoreAPI().usingQueries().usingParams(new String[]{"term=" + childTermWS})).findNodes();
                Assert.assertEquals((int)1, (int)nodesChildTermWS.getEntries().size());
                Assert.assertTrue((nodesChildTerm.getEntries().size() >= nodesChildTermWS.getEntries().size() ? 1 : 0) != 0);
            }
        };
        Utility.sleep((int)300, (int)100000, (RetryOperation)op);
    }
}

