/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes.tasks;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestTaskModel;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.GroupModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.TaskModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetProcessTasksCoreTests
extends RestTest {
    private FileModel document;
    private FileModel document1;
    private FileModel document2;
    private SiteModel siteModel;
    private UserModel userWhoStartsProcess;
    private UserModel candidate;
    private UserModel anotherAssignee;
    private UserModel assignee;
    private ProcessModel process;
    private GroupModel group;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.userWhoStartsProcess = this.dataUser.createRandomTestUser();
        this.candidate = this.dataUser.createRandomTestUser();
        this.anotherAssignee = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userWhoStartsProcess)).createPublicRandomSite();
        this.document = ((DataContent)this.dataContent.usingUser(this.userWhoStartsProcess).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.document1 = ((DataContent)this.dataContent.usingUser(this.userWhoStartsProcess).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.document2 = ((DataContent)this.dataContent.usingUser(this.userWhoStartsProcess).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.process = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsProcess)).usingSite(this.siteModel)).usingResource((ContentModel)this.document)).createSingleReviewerTaskAndAssignTo(this.assignee);
        this.group = this.dataGroup.createRandomGroup();
        this.dataGroup.addListOfUsersToGroup(this.group, new UserModel[]{this.candidate});
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="getProcessTasks with user that is candidate with REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessTasksWithUserThatIsCandidate() throws Exception {
        ProcessModel processModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsProcess)).usingSite(this.siteModel)).usingResource((ContentModel)this.document1)).createGroupReviewTaskAndAssignTo(this.group);
        ((RestModels)this.restClient.authenticateUser(this.candidate).withWorkflowAPI().usingProcess(processModel).getProcessTasks().assertThat().entriesListIsNotEmpty()).and().entriesListContains("assignee", this.candidate.getUsername());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="getProcessTasks for invalid processId with REST API and status code is NOT_FOUND (404)")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessTasksUsingInvalidProcessId() throws Exception {
        ProcessModel processModel = this.process;
        processModel.setId("invalidProcessId");
        this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().usingProcess(processModel).getProcessTasks().assertThat().entriesListIsEmpty();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, ""));
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="getProcessTasks for empty processId with REST API and status code is NOT_FOUND (404)")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessTasksUsingEmptyProcessId() throws Exception {
        ProcessModel processModel = this.process;
        processModel.setId("");
        this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().usingProcess(processModel).getProcessTasks().assertThat().entriesListIsEmpty();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, ""));
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="User completes task then getProcessTasks with REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void completeTaskThenGetProcessTasks() throws Exception {
        ProcessModel processModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsProcess)).usingSite(this.siteModel)).usingResource((ContentModel)this.document2)).createMoreReviewersWorkflowAndAssignTo(new UserModel[]{this.anotherAssignee});
        RestTaskModel restTaskModel = ((RestTaskModel)((RestModels)this.restClient.authenticateUser(this.anotherAssignee).withWorkflowAPI().usingProcess(processModel).getProcessTasks().assertThat().entriesListIsNotEmpty()).getOneRandomEntry()).onModel();
        restTaskModel = this.restClient.withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask((TaskModel)restTaskModel).updateTask("completed");
        ((RestTaskModel)restTaskModel.assertThat().field("id").is((Object)restTaskModel.getId())).and().field("state").is((Object)"completed");
        this.restClient.withWorkflowAPI().getTasks().assertThat().entriesListIsEmpty();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }
}

