/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.repo.resource.general;

import java.util.List;
import java.util.random.RandomGenerator;
import org.alfresco.rest.model.RestCategoryModel;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.TestModel;
import org.alfresco.utility.model.UserModel;

public interface MultiCreator<RESOURCE extends TestModel, SELF extends MultiCreator<RESOURCE, ?>> {
    public SELF withNames(String ... var1);

    public <USER extends UserModel> SELF asUser(USER var1);

    public List<RESOURCE> create();

    public static interface CategoriesCreator
    extends MultiCreator<RestCategoryModel, CategoriesCreator> {
        public <CATEGORY extends RestCategoryModel> CategoriesCreator underCategory(CATEGORY var1);
    }

    public static interface FilesCreator
    extends ContentsCreator<FileModel, FilesCreator> {
        public FilesCreator ofTypes(FileType ... var1);

        public FilesCreator withContents(List<String> var1);

        default public FilesCreator withRandomContents() {
            return this.withRandomContents(RandomGenerator.getDefault().nextInt(30, 70), 10);
        }

        public FilesCreator withRandomContents(int var1, int var2);
    }

    public static interface FoldersCreator
    extends ContentsCreator<FolderModel, FoldersCreator> {
    }

    public static interface ContentsCreator<MODEL extends ContentModel, SELF extends ContentsCreator<MODEL, ?>>
    extends MultiCreator<MODEL, SELF> {
        public SELF withTitles(String ... var1);

        public SELF withRandomTitles();

        public SELF withDescriptions(String ... var1);

        public SELF withRandomDescriptions();

        public <FOLDER extends FolderModel> SELF underFolder(FOLDER var1);

        public <SITE extends SiteModel> SELF withinSite(SITE var1);
    }
}

