/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.repo.resource.content;

import java.util.Map;
import org.alfresco.rest.repo.resource.content.NestedFoldersCreator;
import org.alfresco.rest.repo.resource.content.SerialFoldersCreator;
import org.alfresco.rest.repo.resource.general.ContentCreator;
import org.alfresco.rest.repo.resource.general.Creator;
import org.alfresco.rest.repo.resource.general.MultiCreator;
import org.alfresco.rest.repo.resource.general.Specifier;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.model.FolderModel;

public class RepoFolderCreator
extends ContentCreator<FolderModel, Creator.FolderCreator>
implements Creator.FolderCreator,
Specifier.FolderSpecifier {
    private final DataContent dataContent;
    private final Map<String, FolderModel> foldersCache;

    public RepoFolderCreator(DataContent dataContent, Map<String, FolderModel> foldersCache) {
        super(new FolderModel());
        this.dataContent = dataContent;
        this.foldersCache = foldersCache;
    }

    @Override
    protected RepoFolderCreator self() {
        return this;
    }

    @Override
    public Creator.FolderCreator folder(String name) {
        return (Creator.FolderCreator)this.withName(name);
    }

    @Override
    public Creator.FolderCreator randomFolder() {
        return (Creator.FolderCreator)this.withRandomName();
    }

    @Override
    public Creator.FolderCreator randomFolder(String prefix) {
        return this.withRandomName(prefix);
    }

    @Override
    public MultiCreator.FoldersCreator folders(String ... names) {
        return (MultiCreator.FoldersCreator)((MultiCreator.FoldersCreator)((MultiCreator.FoldersCreator)new SerialFoldersCreator(this.dataContent, this.foldersCache).withNames(names)).withinSite(this.site)).asUser(this.user);
    }

    @Override
    public MultiCreator.FoldersCreator randomFolders(String ... prefixes) {
        return (MultiCreator.FoldersCreator)((MultiCreator.FoldersCreator)((MultiCreator.FoldersCreator)new SerialFoldersCreator(this.dataContent, this.foldersCache).withRandomNames(prefixes)).withinSite(this.site)).asUser(this.user);
    }

    @Override
    public MultiCreator.FoldersCreator randomFolders(int quantity) {
        return (MultiCreator.FoldersCreator)((MultiCreator.FoldersCreator)((MultiCreator.FoldersCreator)new SerialFoldersCreator(this.dataContent, this.foldersCache).withRandomNames(quantity)).withinSite(this.site)).asUser(this.user);
    }

    @Override
    public MultiCreator.FoldersCreator nestedFolders(String ... names) {
        return (MultiCreator.FoldersCreator)((MultiCreator.FoldersCreator)((MultiCreator.FoldersCreator)new NestedFoldersCreator(this.dataContent, this.foldersCache).withNames(names)).withinSite(this.site)).asUser(this.user);
    }

    @Override
    public MultiCreator.FoldersCreator nestedRandomFolders(String ... prefixes) {
        return (MultiCreator.FoldersCreator)((MultiCreator.FoldersCreator)((MultiCreator.FoldersCreator)new NestedFoldersCreator(this.dataContent, this.foldersCache).withRandomNames(prefixes)).withinSite(this.site)).asUser(this.user);
    }

    @Override
    public MultiCreator.FoldersCreator nestedRandomFolders(int depth) {
        return (MultiCreator.FoldersCreator)((MultiCreator.FoldersCreator)((MultiCreator.FoldersCreator)new NestedFoldersCreator(this.dataContent, this.foldersCache).withRandomNames(depth)).withinSite(this.site)).asUser(this.user);
    }

    @Override
    public Creator.FolderCreator withRandomName(String prefix) {
        this.withAlias(prefix);
        return (Creator.FolderCreator)super.withRandomName(prefix);
    }

    @Override
    public FolderModel create() {
        FolderModel createdFolder = this.create(this.dataContent, arg_0 -> ((DataContent)this.dataContent).createFolder(arg_0));
        this.foldersCache.put(this.alias, createdFolder);
        return createdFolder;
    }

    @Override
    protected String generateRandomName() {
        return this.generateRandomNameWith("");
    }

    @Override
    protected String generateRandomNameWith(String prefix) {
        return super.generateRandomNameWith("folder" + prefix + "_");
    }
}

