/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.nodes;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestNodeAssocTargetModel;
import org.alfresco.rest.model.RestNodeAssociationModel;
import org.alfresco.rest.model.RestNodeAssociationModelCollection;
import org.alfresco.rest.model.builder.NodesBuilder;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class NodesTargetSourcesTests
extends RestTest {
    private UserModel adminUserModel;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUserModel = this.dataUser.getAdminUser();
    }

    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY}, description="Check /targets (create, list, delete) api calls")
    @Test(groups={"rest-api", "nodes", "sanity"})
    public void checkTargetsNodeApi() throws Exception {
        Step.STEP((String)"1.Create folder1 which contains 3 files: f1, f2, and f3");
        NodesBuilder nodesBuilder = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingNode((RepoTestModel)ContentModel.my()).defineNodes();
        nodesBuilder.folder("F1").file("f1").file("f2").file("f3");
        Step.STEP((String)"2. Create target associations model objects");
        RestNodeAssocTargetModel assocDocTarget1 = new RestNodeAssocTargetModel(nodesBuilder.getNode("f2").toContentModel().getNodeRef(), "cm:references");
        RestNodeAssocTargetModel assocDocTarget2 = new RestNodeAssocTargetModel(nodesBuilder.getNode("f3").toContentModel().getNodeRef(), "cm:references");
        Step.STEP((String)"3. Create target  associations using POST /nodes/{nodeId}/targets");
        this.restClient.withCoreAPI().usingResource((RepoTestModel)nodesBuilder.getNode("f1").toContentModel()).createTargetForNode(assocDocTarget1);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)nodesBuilder.getNode("f1").toContentModel()).createTargetForNode(assocDocTarget2);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"4. Check using GET /nodes/{nodeId}/targets targets associations were created");
        RestNodeAssociationModelCollection targetsRes = this.restClient.withParams(new String[]{"where=(assocType='cm:references')"}).withCoreAPI().usingResource((RepoTestModel)nodesBuilder.getNode("f1").toContentModel()).getNodeTargets();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        targetsRes.assertThat().entriesListCountIs(2);
        ((RestNodeAssociationModel)((RestNodeAssociationModel)targetsRes.getEntryByIndex(0)).assertThat().field("association.assocType").is((Object)"cm:references")).and().field("name").is((Object)nodesBuilder.getNode("f2").getName());
        ((RestNodeAssociationModel)((RestNodeAssociationModel)targetsRes.getEntryByIndex(1)).assertThat().field("association.assocType").is((Object)"cm:references")).and().field("name").is((Object)nodesBuilder.getNode("f3").getName());
        Step.STEP((String)"5. Check using DELETE /nodes/{nodeId}/targets/{targetId} that a target can be deleted");
        this.restClient.authenticateUser(this.adminUserModel);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)nodesBuilder.getNode("f1").toContentModel()).deleteTarget(assocDocTarget1);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        Step.STEP((String)"6. Check using GET /nodes/{nodeId}/targets that target association was deleted");
        targetsRes = this.restClient.withParams(new String[]{"where=(assocType='cm:references')"}).withCoreAPI().usingResource((RepoTestModel)nodesBuilder.getNode("f1").toContentModel()).getNodeTargets();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        targetsRes.assertThat().entriesListCountIs(1);
        ((RestNodeAssociationModel)targetsRes.getEntryByIndex(0)).assertThat().field("association.assocType").is((Object)"cm:references");
    }

    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY}, description="Check that source objects are retrieved using GET /nodes/{nodeId}/sources")
    @Test(groups={"rest-api", "nodes", "sanity"})
    public void checkGetNodeSources() throws Exception {
        Step.STEP((String)"1.Create a folder hierarchy folder1 containing 4 files: f1, f2, and f3");
        NodesBuilder nodesBuilder = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingNode((RepoTestModel)ContentModel.my()).defineNodes();
        nodesBuilder.folder("F1").file("f1").file("f2").file("f3");
        Step.STEP((String)"2. Create target associations model objects");
        RestNodeAssocTargetModel assocDocTarget1 = new RestNodeAssocTargetModel(nodesBuilder.getNode("f3").toContentModel().getNodeRef(), "cm:references");
        RestNodeAssocTargetModel assocDocTarget2 = new RestNodeAssocTargetModel(nodesBuilder.getNode("f3").toContentModel().getNodeRef(), "cm:preferenceImage");
        Step.STEP((String)"3. Create target  associations using POST /nodes/{nodeId}/targets");
        this.restClient.authenticateUser(this.adminUserModel);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)nodesBuilder.getNode("f1").toContentModel()).createTargetForNode(assocDocTarget1);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)nodesBuilder.getNode("f2").toContentModel()).createTargetForNode(assocDocTarget2);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"4. Check using GET /nodes/{nodeId}/sources that all source associations are displayed");
        RestNodeAssociationModelCollection sources = this.restClient.withCoreAPI().usingResource((RepoTestModel)nodesBuilder.getNode("f3").toContentModel()).getNodeSources();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        sources.assertThat().entriesListCountIs(2);
        Step.STEP((String)"5. Check using GET /nodes/{nodeId}/sources with params that sources and fields can be filtered in the response");
        sources = this.restClient.withParams(new String[]{"where=(assocType='cm:references')", "fields=isFile,name,association,id,nodeType,parentId"}).withCoreAPI().usingResource((RepoTestModel)nodesBuilder.getNode("f3").toContentModel()).getNodeSources();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        sources.assertThat().entriesListCountIs(1);
        ((RestNodeAssociationModel)((RestNodeAssociationModel)((RestNodeAssociationModel)((RestNodeAssociationModel)((RestNodeAssociationModel)((RestNodeAssociationModel)sources.getEntryByIndex(0)).assertThat().field("isFile").is((Object)true)).and().field("name").is((Object)nodesBuilder.getNode("f1").getName())).and().field("id").is((Object)nodesBuilder.getNode("f1").getId())).and().field("id").is((Object)nodesBuilder.getNode("f1").getId())).and().field("nodeType").is((Object)"cm:content")).getAssociation().assertThat().field("assocType").is((Object)"cm:references");
    }
}

