/*-
 * #%L
 * alfresco-tas-restapi
 * %%
 * Copyright (C) 2005 - 2022 Alfresco Software Limited
 * %%
 * This file is part of the Alfresco software. 
 * If the software was purchased under a paid Alfresco license, the terms of 
 * the paid license agreement will prevail.  Otherwise, the software is 
 * provided under the following open source license terms:
 * 
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.alfresco.rest.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

import org.alfresco.rest.core.IRestModel;
import org.alfresco.rest.search.RestGenericMetricModel;
import org.alfresco.utility.model.TestModel;

/**
 * Generated by 'msuzuki' on '2017-05-15 13:08' from 'Alfresco Search REST API' swagger file Generated from 'Alfresco Search REST API' swagger file Base Path {@linkplain /alfresco/api/-default-/public/search/versions/1}
 */
public class RestGenericBucketModel extends TestModel implements IRestModel<RestGenericBucketModel>
{
    @JsonProperty(value = "entry")
    RestGenericBucketModel model;

    @Override
    public RestGenericBucketModel onModel()
    {
        return model;
    }

    /**
     * The bucket label
     */

    private String label;
    /**
     * The filter query you can use to apply this facet
     */

    private String filterQuery;
    /**
     * An optional field for additional display information
     */

    private Object display;
    /**
     * An array of buckets and values
     */

    private List<RestGenericMetricModel> metrics;
    /**
     * Additional list of nested facets
     */

    private List<Object> facets;
    /**
     * Additional information of nested facet
     */

    private Object facetInfo;

    public String getLabel()
    {
        return this.label;
    }

    public void setLabel(String label)
    {
        this.label = label;
    }

    public String getFilterQuery()
    {
        return this.filterQuery;
    }

    public void setFilterQuery(String filterQuery)
    {
        this.filterQuery = filterQuery;
    }

    public Object getDisplay()
    {
        return this.display;
    }

    public void setDisplay(Object display)
    {
        this.display = display;
    }

    public List<RestGenericMetricModel> getMetrics()
    {
        return this.metrics;
    }

    public void setMetrics(List<RestGenericMetricModel> metrics)
    {
        this.metrics = metrics;
    }

    public List<Object> getFacets()
    {
        return this.facets;
    }

    public void setFacets(List<Object> facets)
    {
        this.facets = facets;
    }

    public Object getFacetInfo()
    {
        return this.facetInfo;
    }

    public void setFacetInfo(Object facetInfo)
    {
        this.facetInfo = facetInfo;
    }
}
