/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.repo.resource;

import java.util.Map;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.repo.resource.ResourceManager;
import org.alfresco.rest.repo.resource.cache.MultiKeyResourceMap;
import org.alfresco.rest.repo.resource.content.PlainFileCreator;
import org.alfresco.rest.repo.resource.content.PlainFileModifier;
import org.alfresco.rest.repo.resource.general.Creator;
import org.alfresco.rest.repo.resource.general.Modifier;
import org.alfresco.rest.repo.resource.general.Specifier;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class Files
implements ResourceManager<FileModel, Specifier.FileSpecifier, Modifier.FileModifier> {
    public static final String FILE_NAME_PREFIX = "file";
    private final DataContent dataContent;
    private final RestWrapper restClient;
    private final SiteModel site;
    private final UserModel user;
    private final Map<String, FileModel> filesCache = new MultiKeyResourceMap<FileModel>(RepoTestModel::getNodeRef, ContentModel::getName);

    public Files(DataContent dataContent, RestWrapper restClient, UserModel user, SiteModel site) {
        this.dataContent = dataContent;
        this.restClient = restClient;
        this.user = user;
        this.site = site;
    }

    public Files(DataContent dataContent, RestWrapper restClient, DataUser dataUser) {
        this(dataContent, restClient, dataUser.getAdminUser(), null);
    }

    @Autowired
    public Files(DataContent dataContent, RestWrapper restClient, DataUser dataUser, DataSite dataSite) {
        this(dataContent, restClient, dataUser.getAdminUser(), ((DataSite)dataSite.usingUser(dataUser.getAdminUser())).createPrivateRandomSite());
    }

    @Override
    public Specifier.FileSpecifier add() {
        return (Specifier.FileSpecifier)((Creator.FileCreator)new PlainFileCreator(this.dataContent, this.filesCache).withinSite(this.site)).asUser(this.user);
    }

    @Override
    public FileModel get(String id) {
        return this.filesCache.get(id);
    }

    @Override
    public Modifier.FileModifier modify(FileModel file) {
        return (Modifier.FileModifier)((Modifier.FileModifier)new PlainFileModifier(this.dataContent, this.restClient, file, this.filesCache).withinSite(this.site)).asUser(this.user);
    }

    @Override
    public void delete(FileModel file) {
        ((Modifier.FileModifier)((Modifier.FileModifier)new PlainFileModifier(this.dataContent, this.restClient, file, this.filesCache).withinSite(this.site)).asUser(this.user)).delete();
    }
}

