/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.deployments;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.exception.JsonToModelConversionException;
import org.alfresco.rest.model.RestDeploymentModel;
import org.alfresco.rest.model.RestDeploymentModelsCollection;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetDeploymentsFullTests
extends RestTest {
    private UserModel adminUserModel;
    private RestDeploymentModelsCollection deployments;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUserModel = this.dataUser.getAdminUser();
        this.restClient.authenticateUser(this.adminUserModel);
    }

    @TestRail(section={"rest-api", "workflow", "deployments"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user gets non-network deployments with skipCount parameter applied using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "deployments", "regression"})
    public void getNonNetworkDeploymentsWithValidSkipCount() throws JsonToModelConversionException, Exception {
        this.deployments = this.restClient.withWorkflowAPI().getDeployments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        RestDeploymentModel firstDeployment = ((RestDeploymentModel)this.deployments.getEntries().get(0)).onModel();
        RestDeploymentModel secondDeployment = ((RestDeploymentModel)this.deployments.getEntries().get(1)).onModel();
        RestDeploymentModelsCollection deploymentsWithSkipCount = this.restClient.withParams(new String[]{"skipCount=2"}).withWorkflowAPI().getDeployments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)deploymentsWithSkipCount.assertThat().entriesListDoesNotContain("name", firstDeployment.getName())).assertThat().entriesListDoesNotContain("name", secondDeployment.getName())).assertThat().entriesListCountIs(this.deployments.getEntries().size() - 2);
        deploymentsWithSkipCount.assertThat().paginationField("skipCount").is("2");
    }

    @TestRail(section={"rest-api", "workflow", "deployments"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user doesn't get non-network deployments when negative skipCount parameter is applied using REST API and status code is 400")
    @Test(groups={"rest-api", "workflow", "deployments", "regression"})
    public void getNonNetworkDeploymentsWithNegativeSkipCount() throws JsonToModelConversionException, Exception {
        this.restClient.withParams(new String[]{"skipCount=-1"}).withWorkflowAPI().getDeployments();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.NEGATIVE_VALUES_SKIPCOUNT).containsErrorKey(RestErrorModel.NEGATIVE_VALUES_SKIPCOUNT).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE).statusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @TestRail(section={"rest-api", "workflow", "deployments"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user doesn't get non-network deployments when non numeric skipCount parameter is applied using REST API and status code is 400")
    @Test(groups={"rest-api", "workflow", "deployments", "regression"})
    public void getNonNetworkDeploymentsWithNotNumericSkipCount() throws JsonToModelConversionException, Exception {
        this.restClient.withParams(new String[]{"skipCount=A"}).withWorkflowAPI().getDeployments();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_SKIPCOUNT, "A"));
    }

    @TestRail(section={"rest-api", "workflow", "deployments"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user gets non-network deployments with maxItems parameter applied using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "deployments", "regression"})
    public void getNonNetworkDeploymentsWithValidMaxItems() throws JsonToModelConversionException, Exception {
        this.deployments = this.restClient.withWorkflowAPI().getDeployments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        RestDeploymentModel firstDeployment = ((RestDeploymentModel)this.deployments.getEntries().get(0)).onModel();
        RestDeploymentModel secondDeployment = ((RestDeploymentModel)this.deployments.getEntries().get(1)).onModel();
        RestDeploymentModelsCollection deploymentsWithMaxItems = this.restClient.withParams(new String[]{"maxItems=2"}).withWorkflowAPI().getDeployments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)deploymentsWithMaxItems.assertThat().entriesListContains("name", firstDeployment.getName())).assertThat().entriesListContains("name", secondDeployment.getName())).assertThat().entriesListCountIs(2);
        deploymentsWithMaxItems.assertThat().paginationField("maxItems").is("2");
    }

    @TestRail(section={"rest-api", "workflow", "deployments"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user doesn't get non-network deployments when negative maxItems parameter is applied using REST API and status code is 400")
    @Test(groups={"rest-api", "workflow", "deployments", "regression"})
    public void getNonNetworkDeploymentsWithNegativeMaxItems() throws JsonToModelConversionException, Exception {
        this.restClient.withParams(new String[]{"maxItems=-1"}).withWorkflowAPI().getDeployments();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS).containsErrorKey(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE).statusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @TestRail(section={"rest-api", "workflow", "deployments"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user doesn't get non-network deployments when non numeric maxItems parameter is applied using REST API and status code is 400")
    @Test(groups={"rest-api", "workflow", "deployments", "regression"})
    public void getNonNetworkDeploymentsWithNotNumericMaxItems() throws JsonToModelConversionException, Exception {
        this.restClient.withParams(new String[]{"maxItems=A"}).withWorkflowAPI().getDeployments();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_MAXITEMS, "A"));
    }

    @TestRail(section={"rest-api", "workflow", "deployments"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user gets non-network deployments with properties parameter applied using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "deployments", "regression"})
    public void getNonNetworkDeploymentsWithValidProperties() throws JsonToModelConversionException, Exception {
        this.deployments = this.restClient.withParams(new String[]{"properties=name"}).withWorkflowAPI().getDeployments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.deployments.assertThat().entriesListIsNotEmpty();
        ((RestDeploymentModel)((RestDeploymentModel)((RestDeploymentModel)((RestDeploymentModel)this.deployments.getOneRandomEntry()).onModel().assertThat().fieldsCount().is((Object)1)).and().field("id").isNull()).and().field("deployedAt").isNull()).and().field("name").isNotEmpty();
    }

    @TestRail(section={"rest-api", "workflow", "deployments"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user gets non-network deployments with non existing properties parameter applied using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "deployments", "regression"})
    public void getNonNetworkDeploymentsWithNonExistingProperties() throws JsonToModelConversionException, Exception {
        this.deployments = this.restClient.withParams(new String[]{"properties=TAS"}).withWorkflowAPI().getDeployments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.deployments.assertThat().entriesListIsNotEmpty();
        ((RestDeploymentModel)((RestDeploymentModel)((RestDeploymentModel)((RestDeploymentModel)this.deployments.getOneRandomEntry()).onModel().assertThat().fieldsCount().is((Object)0)).and().field("id").isNull()).and().field("deployedAt").isNull()).and().field("name").isNull();
    }
}

