/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processDefinitions;

import java.util.Arrays;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestFormModel;
import org.alfresco.rest.model.RestFormModelsCollection;
import org.alfresco.rest.model.RestProcessDefinitionModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetProcessDefinitionStartFormModelFullTests
extends RestTest {
    private UserModel adminUser;
    private RestProcessDefinitionModel activitiAdhoc;
    private RestFormModelsCollection returnedResponse;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.activitiAdhoc = this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getAllProcessDefinitions().getProcessDefinitionByDeploymentId("1");
    }

    @TestRail(section={"rest-api", "workflow", "process-definitions"}, executionType={ExecutionType.REGRESSION}, description="Verify admin gets a model of the start form type definition for specific process definition using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "process-definitions", "regression"})
    public void adminGetsStartFormModelForActivitiAdhocProcessDefinition() throws Exception {
        this.returnedResponse = this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().usingProcessDefinitions(this.activitiAdhoc).getProcessDefinitionStartFormModel();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.returnedResponse.assertThat().entriesListContains("qualifiedName", "{http://www.alfresco.org/model/bpm/1.0}workflowPriority");
        ((RestFormModel)((RestFormModel)((RestFormModel)((RestFormModel)((RestFormModel)this.returnedResponse.getStartFormModelByQualifiedName("{http://www.alfresco.org/model/bpm/1.0}workflowPriority").assertThat().field("defaultValue").is((Object)"2")).and().field("dataType").is((Object)"d:int")).and().field("name").is((Object)"bpm_workflowPriority")).and().field("title").is((Object)"Workflow Priority")).and().field("required").is((Object)"false")).and().field("allowedValues").is(Arrays.asList("1", "2", "3"));
    }

    @TestRail(section={"rest-api", "workflow", "process-definitions"}, executionType={ExecutionType.REGRESSION}, description="Verify admin gets a model of the start form type definition with properties parameter applied using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "process-definitions", "regression"})
    public void adminGetsStartFormModelWithPropertiesParameterApplied() throws Exception {
        this.returnedResponse = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"properties=qualifiedName,dataType,title"}).withWorkflowAPI().usingProcessDefinitions(this.activitiAdhoc).getProcessDefinitionStartFormModel();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.returnedResponse.assertThat().entriesListContains("qualifiedName", "{http://www.alfresco.org/model/bpm/1.0}workflowPriority");
        ((RestFormModel)((RestFormModel)((RestFormModel)((RestFormModel)((RestFormModel)((RestFormModel)((RestFormModel)this.returnedResponse.getStartFormModelByQualifiedName("{http://www.alfresco.org/model/bpm/1.0}workflowPriority").assertThat().fieldsCount().is((Object)3)).and().field("qualifiedName").is((Object)"{http://www.alfresco.org/model/bpm/1.0}workflowPriority")).and().field("defaultValue").isNull()).and().field("dataType").is((Object)"d:int")).and().field("name").isNull()).and().field("title").is((Object)"Workflow Priority")).and().field("required").isNull()).and().field("allowedValues").isNull();
    }
}

