/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.tasks.items;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestItemModel;
import org.alfresco.rest.model.RestItemModelsCollection;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.TaskModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AddTaskItemTestsBulk1
extends RestTest {
    private UserModel userModel;
    private UserModel userWhoStartsTask;
    private UserModel assigneeUser;
    private SiteModel siteModel;
    private FileModel fileModel;
    private FileModel document2;
    private FileModel document3;
    private TaskModel taskModel;
    private RestItemModelsCollection taskItems;
    private RestItemModel taskItem;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.userModel = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.fileModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.userWhoStartsTask = this.dataUser.createRandomTestUser();
        this.assigneeUser = this.dataUser.createRandomTestUser();
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assigneeUser);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Create non-existing task item")
    public void createTaskItem() throws Exception {
        UserModel adminUser = this.dataUser.getAdminUser();
        this.restClient.authenticateUser(adminUser);
        this.document2 = ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.XML);
        this.taskItem = this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskItem(this.document2);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)this.taskItem.assertThat().field("createdAt").is((Object)this.taskItem.getCreatedAt())).assertThat().field("size").is((Object)this.taskItem.getSize())).assertThat().field("createdBy").is((Object)this.taskItem.getCreatedBy())).assertThat().field("modifiedAt").is((Object)this.taskItem.getModifiedAt())).assertThat().field("name").is((Object)this.taskItem.getName())).assertThat().field("modifiedBy").is((Object)this.taskItem.getModifiedBy())).assertThat().field("id").is((Object)this.taskItem.getId())).assertThat().field("mimeType").is((Object)this.taskItem.getMimeType());
    }

    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Create multiple non-existing task item")
    public void createMultipleTaskItem() throws Exception {
        UserModel adminUser = this.dataUser.getAdminUser();
        this.restClient.authenticateUser(adminUser);
        this.document2 = ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.XML);
        this.taskItems = this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskItems(new FileModel[]{this.document2, this.fileModel});
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)this.taskItems.getEntries().get(0)).onModel().assertThat().field("createdAt").is((Object)((RestItemModel)this.taskItems.getEntries().get(0)).onModel().getCreatedAt())).assertThat().field("size").is((Object)((RestItemModel)this.taskItems.getEntries().get(0)).onModel().getSize())).assertThat().field("createdBy").is((Object)((RestItemModel)this.taskItems.getEntries().get(0)).onModel().getCreatedBy())).assertThat().field("modifiedAt").is((Object)((RestItemModel)this.taskItems.getEntries().get(0)).onModel().getModifiedAt())).assertThat().field("name").is((Object)((RestItemModel)this.taskItems.getEntries().get(0)).onModel().getName())).assertThat().field("modifiedBy").is((Object)((RestItemModel)this.taskItems.getEntries().get(0)).onModel().getModifiedBy())).assertThat().field("id").is((Object)((RestItemModel)this.taskItems.getEntries().get(0)).onModel().getId())).assertThat().field("mimeType").is((Object)((RestItemModel)this.taskItems.getEntries().get(0)).onModel().getMimeType());
        ((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)this.taskItems.getEntries().get(1)).onModel().assertThat().field("createdAt").is((Object)((RestItemModel)this.taskItems.getEntries().get(1)).onModel().getCreatedAt())).assertThat().field("size").is((Object)((RestItemModel)this.taskItems.getEntries().get(1)).onModel().getSize())).assertThat().field("createdBy").is((Object)((RestItemModel)this.taskItems.getEntries().get(1)).onModel().getCreatedBy())).assertThat().field("modifiedAt").is((Object)((RestItemModel)this.taskItems.getEntries().get(1)).onModel().getModifiedAt())).assertThat().field("name").is((Object)((RestItemModel)this.taskItems.getEntries().get(1)).onModel().getName())).assertThat().field("modifiedBy").is((Object)((RestItemModel)this.taskItems.getEntries().get(1)).onModel().getModifiedBy())).assertThat().field("id").is((Object)((RestItemModel)this.taskItems.getEntries().get(1)).onModel().getId())).assertThat().field("mimeType").is((Object)((RestItemModel)this.taskItems.getEntries().get(1)).onModel().getMimeType());
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @Bug(id="MNT-16966")
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that in case task item exists the request fails")
    public void createTaskItemThatAlreadyExists() throws Exception {
        UserModel adminUser = this.dataUser.getAdminUser();
        this.restClient.authenticateUser(adminUser);
        this.document3 = ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.XML);
        this.taskItem = this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskItem(this.document3);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)this.taskItem.assertThat().field("createdAt").is((Object)this.taskItem.getCreatedAt())).assertThat().field("size").is((Object)this.taskItem.getSize())).and().field("createdBy").is((Object)this.taskItem.getCreatedBy())).and().field("modifiedAt").is((Object)this.taskItem.getModifiedAt())).and().field("name").is((Object)this.taskItem.getName())).and().field("modifiedBy").is((Object)this.taskItem.getModifiedBy())).and().field("id").is((Object)this.taskItem.getId())).and().field("mimeType").is((Object)this.taskItem.getMimeType());
        this.taskItem = this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskItem(this.document3);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @Bug(id="MNT-16966")
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that in case task item exists the request fails")
    public void createMultipleTaskItemThatAlreadyExists() throws Exception {
        UserModel adminUser = this.dataUser.getAdminUser();
        this.restClient.authenticateUser(adminUser);
        this.document3 = ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.XML);
        this.document2 = ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.XML);
        this.taskItems = this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskItems(new FileModel[]{this.document3, this.document2});
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)this.taskItems.getEntries().get(0)).onModel().assertThat().field("createdAt").is((Object)((RestItemModel)this.taskItems.getEntries().get(0)).onModel().getCreatedAt())).assertThat().field("size").is((Object)((RestItemModel)this.taskItems.getEntries().get(0)).onModel().getSize())).assertThat().field("createdBy").is((Object)((RestItemModel)this.taskItems.getEntries().get(0)).onModel().getCreatedBy())).assertThat().field("modifiedAt").is((Object)((RestItemModel)this.taskItems.getEntries().get(0)).onModel().getModifiedAt())).assertThat().field("name").is((Object)((RestItemModel)this.taskItems.getEntries().get(0)).onModel().getName())).assertThat().field("modifiedBy").is((Object)((RestItemModel)this.taskItems.getEntries().get(0)).onModel().getModifiedBy())).assertThat().field("id").is((Object)((RestItemModel)this.taskItems.getEntries().get(0)).onModel().getId())).assertThat().field("mimeType").is((Object)((RestItemModel)this.taskItems.getEntries().get(0)).onModel().getMimeType());
        ((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)this.taskItems.getEntries().get(1)).onModel().assertThat().field("createdAt").is((Object)((RestItemModel)this.taskItems.getEntries().get(1)).onModel().getCreatedAt())).assertThat().field("size").is((Object)((RestItemModel)this.taskItems.getEntries().get(1)).onModel().getSize())).assertThat().field("createdBy").is((Object)((RestItemModel)this.taskItems.getEntries().get(1)).onModel().getCreatedBy())).assertThat().field("modifiedAt").is((Object)((RestItemModel)this.taskItems.getEntries().get(1)).onModel().getModifiedAt())).assertThat().field("name").is((Object)((RestItemModel)this.taskItems.getEntries().get(1)).onModel().getName())).assertThat().field("modifiedBy").is((Object)((RestItemModel)this.taskItems.getEntries().get(1)).onModel().getModifiedBy())).assertThat().field("id").is((Object)((RestItemModel)this.taskItems.getEntries().get(1)).onModel().getId())).assertThat().field("mimeType").is((Object)((RestItemModel)this.taskItems.getEntries().get(1)).onModel().getMimeType());
        this.taskItems = this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskItems(new FileModel[]{this.document3, this.document2});
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
    }
}

