/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.people;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.exception.JsonToModelConversionException;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.exception.DataPreparationException;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DeleteSiteMemberSanityTests
extends RestTest {
    private SiteModel siteModel;
    private UserModel adminUser;
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws DataPreparationException {
        this.adminUser = this.dataUser.getAdminUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.adminUser)).createPublicRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.siteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to delete another member of the site")
    public void siteManagerCanDeleteSiteMember() throws JsonToModelConversionException, DataPreparationException, Exception {
        UserModel newUser = this.dataUser.createRandomTestUser("testUser");
        newUser.setUserRole(UserRole.SiteCollaborator);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingSite(this.siteModel).addPerson(newUser);
        this.restClient.withCoreAPI().usingUser(newUser).deleteSiteMember(this.siteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify admin user is able to delete another member of the site")
    public void adminIsAbleToDeleteSiteMember() throws JsonToModelConversionException, DataPreparationException, Exception {
        UserModel newUser = this.dataUser.createRandomTestUser("testUser");
        newUser.setUserRole(UserRole.SiteCollaborator);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingSite(this.siteModel).addPerson(newUser);
        this.restClient.withCoreAPI().usingUser(newUser).deleteSiteMember(this.siteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify site collaborator does not have permission to delete another member of the site")
    public void siteCollaboratorIsNotAbleToDeleteSiteMember() throws JsonToModelConversionException, DataPreparationException, Exception {
        UserModel newUser = this.dataUser.createRandomTestUser("testUser");
        newUser.setUserRole(UserRole.SiteCollaborator);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingSite(this.siteModel).addPerson(newUser);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator));
        this.restClient.withCoreAPI().usingUser(newUser).deleteSiteMember(this.siteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsSummary(String.format(RestErrorModel.NOT_SUFFICIENT_PERMISSIONS, this.siteModel.getId()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor does not have permission to delete another member of the site")
    public void siteContributorIsNotAbleToDeleteSiteMember() throws JsonToModelConversionException, DataPreparationException, Exception {
        UserModel newUser = this.dataUser.createRandomTestUser("testUser");
        newUser.setUserRole(UserRole.SiteCollaborator);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingSite(this.siteModel).addPerson(newUser);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor));
        this.restClient.withCoreAPI().usingUser(newUser).deleteSiteMember(this.siteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsSummary(String.format(RestErrorModel.NOT_SUFFICIENT_PERMISSIONS, this.siteModel.getId()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify site consumer does not have permission to delete another member of the site")
    public void siteConsumerIsNotAbleToDeleteSiteMember() throws JsonToModelConversionException, DataPreparationException, Exception {
        UserModel newUser = this.dataUser.createRandomTestUser("testUser");
        newUser.setUserRole(UserRole.SiteCollaborator);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingSite(this.siteModel).addPerson(newUser);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer));
        this.restClient.withCoreAPI().usingUser(newUser).deleteSiteMember(this.siteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsSummary(String.format(RestErrorModel.NOT_SUFFICIENT_PERMISSIONS, this.siteModel.getId()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify unauthenticated user is not able to delete another member of the site")
    public void unauthenticatedUserIsNotAbleToDeleteSiteMember() throws JsonToModelConversionException, DataPreparationException, Exception {
        this.restClient.authenticateUser(new UserModel("random user", "random password"));
        this.restClient.withCoreAPI().usingUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).deleteSiteMember(this.siteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }
}

