/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.actions.access;

import io.restassured.response.ValidatableResponse;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.actions.access.AccessRestrictionUtil;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.UserModel;
import org.hamcrest.Matchers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class V1AdminAccessRestrictionTest
extends RestTest {
    private UserModel adminUser;
    private UserModel testUser;
    private FolderModel testFolder;
    @Autowired
    protected RestWrapper restClient;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.testUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPublicRandomSite();
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
    }

    @Test
    public void userShouldNotExecuteMailAction() throws Exception {
        this.restClient.authenticateUser(this.testUser).withCoreAPI().usingActions().executeAction("mail", (RepoTestModel)this.testFolder, AccessRestrictionUtil.createMailParameters(this.adminUser, this.testUser));
        ((ValidatableResponse)((ValidatableResponse)this.restClient.onResponse().assertThat().statusCode(HttpStatus.FORBIDDEN.value())).assertThat()).body("entry.id", Matchers.nullValue(), new Object[0]);
        this.restClient.assertLastError().containsSummary("Only admin or system user is allowed to define uses of or directly execute this action");
    }

    @Test
    public void adminShouldExecuteMailAction() throws Exception {
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingActions().executeAction("mail", (RepoTestModel)this.testFolder, AccessRestrictionUtil.createMailParameters(this.adminUser, this.testUser));
        ((ValidatableResponse)((ValidatableResponse)this.restClient.onResponse().assertThat().statusCode(HttpStatus.ACCEPTED.value())).assertThat()).body("entry.id", Matchers.notNullValue(), new Object[0]);
    }
}

