/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.tasks;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestFormModel;
import org.alfresco.rest.model.RestFormModelsCollection;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.TaskModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetTaskFormModelTests
extends RestTest {
    UserModel userModel;
    UserModel adminUser;
    SiteModel siteModel;
    FileModel fileModel;
    TaskModel taskModel;
    RestFormModelsCollection returnedCollection;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userModel = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.fileModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Verify admin user gets all task form models with Rest API and response is successful (200)")
    public void adminGetsTaskFormModels() throws Exception {
        String[] qualifiedNames;
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.userModel);
        this.returnedCollection = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withWorkflowAPI().usingTask(this.taskModel).getTaskFormModel();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.returnedCollection.assertThat().entriesListIsNotEmpty();
        for (String formQualifiedName : qualifiedNames = new String[]{"{http://www.alfresco.org/model/bpm/1.0}percentComplete", "{http://www.alfresco.org/model/bpm/1.0}context", "{http://www.alfresco.org/model/bpm/1.0}completedItems", "{http://www.alfresco.org/model/content/1.0}name", "{http://www.alfresco.org/model/bpm/1.0}packageActionGroup", "{http://www.alfresco.org/model/bpm/1.0}reassignable", "{http://www.alfresco.org/model/content/1.0}owner", "{http://www.alfresco.org/model/bpm/1.0}outcome", "{http://www.alfresco.org/model/bpm/1.0}taskId", "{http://www.alfresco.org/model/bpm/1.0}packageItemActionGroup", "{http://www.alfresco.org/model/bpm/1.0}completionDate"}) {
            this.returnedCollection.assertThat().entriesListContains("qualifiedName", formQualifiedName);
        }
    }

    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Verify user involved in task gets all the task form models with Rest API and response is successful (200)")
    public void involvedUserGetsTaskFormModels() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.userModel);
        this.returnedCollection = this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).getTaskFormModel();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.returnedCollection.assertThat().entriesListIsNotEmpty();
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that non involved user in task cannot get form models with Rest API and response is FORBIDDEN (403)")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void nonInvolvedUserCannotGetTaskFormModels() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.userModel);
        UserModel nonInvolvedUser = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(nonInvolvedUser);
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).getTaskFormModel();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify user involved in task cannot get task form models with invalid task id")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void getTaskFormModelsInvalidTaskId() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.userModel);
        this.taskModel.setId("0000");
        this.restClient.authenticateUser(this.userModel);
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).getTaskFormModel();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "0000"));
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify user involved in task cannot get task form models with invalid task id")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void getTaskFormModelsEmptyTaskId() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.userModel);
        this.taskModel.setId("");
        this.restClient.authenticateUser(this.userModel);
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).getTaskFormModel();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, ""));
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify user involved in task can get completed task form models")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void getTaskFormModelsForCompletedTask() throws Exception {
        UserModel assignedUser = this.dataUser.createRandomTestUser();
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(assignedUser);
        ((DataWorkflow)this.dataWorkflow.usingUser(assignedUser)).taskDone(this.taskModel);
        ((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).taskDone(this.taskModel);
        this.restClient.authenticateUser(this.userModel);
        this.returnedCollection = this.restClient.withWorkflowAPI().usingTask(this.taskModel).getTaskFormModel();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.returnedCollection.assertThat().entriesListIsNotEmpty();
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user gets all task form models with properties parameter applied and response is successful (200)")
    public void adminGetsTaskFormModelsWithPropertiesParameter() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.userModel);
        this.returnedCollection = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"properties=qualifiedName,required"}).withWorkflowAPI().usingTask(this.taskModel).getTaskFormModel();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.returnedCollection.assertThat().entriesListIsNotEmpty();
        ((RestFormModel)((RestFormModel)((RestFormModel)((RestFormModel)((RestFormModel)((RestFormModel)((RestFormModel)((RestFormModel)this.returnedCollection.getOneRandomEntry()).onModel().assertThat().field("qualifiedName").isNotEmpty()).and().field("required").isNotEmpty()).and().field("dataType").isNull()).and().field("name").isNull()).and().field("title").isNull()).and().field("defaultValue").isNull()).and().field("allowedValues").isNull()).and().fieldsCount().is((Object)2);
    }

    @Bug(id="MNT-17438")
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify admin gets task form model with valid skipCount parameter applied using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void getTaskFormModelWithValidSkipCount() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.userModel);
        this.returnedCollection = this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().usingTask(this.taskModel).getTaskFormModel();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        RestFormModel firstTaskFormModel = ((RestFormModel)this.returnedCollection.getEntries().get(0)).onModel();
        RestFormModel secondTaskFormModel = ((RestFormModel)this.returnedCollection.getEntries().get(1)).onModel();
        RestFormModelsCollection formModelsWithSkipCount = this.restClient.withParams(new String[]{"skipCount=2"}).withWorkflowAPI().usingTask(this.taskModel).getTaskFormModel();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)formModelsWithSkipCount.assertThat().entriesListDoesNotContain("name", firstTaskFormModel.getName())).assertThat().entriesListDoesNotContain("name", secondTaskFormModel.getName())).assertThat().entriesListCountIs(this.returnedCollection.getEntries().size() - 2);
        formModelsWithSkipCount.assertThat().paginationField("skipCount").is("2");
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify admin doesn't get task form model with negative skipCount parameter applied using REST API")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void getTaskFormModelWithNegativeSkipCount() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.userModel);
        this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"skipCount=-1"}).withWorkflowAPI().usingTask(this.taskModel).getTaskFormModel();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.NEGATIVE_VALUES_SKIPCOUNT).containsErrorKey(RestErrorModel.NEGATIVE_VALUES_SKIPCOUNT).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE).statusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify admin doesn't get task form model with non numeric skipCount parameter applied using REST API")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void getTaskFormModelWithNonNumericSkipCount() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.userModel);
        this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"skipCount=A"}).withWorkflowAPI().usingTask(this.taskModel).getTaskFormModel();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_SKIPCOUNT, "A"));
    }

    @Bug(id="MNT-17438")
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify admin gets task form model with valid maxItems parameter applied using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void getTaskFormModelWithValidMaxItems() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.userModel);
        this.returnedCollection = this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().usingTask(this.taskModel).getTaskFormModel();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        RestFormModel firstTaskFormModel = ((RestFormModel)this.returnedCollection.getEntries().get(0)).onModel();
        RestFormModel secondTaskFormModel = ((RestFormModel)this.returnedCollection.getEntries().get(1)).onModel();
        RestFormModelsCollection formModelsWithMaxItems = this.restClient.withParams(new String[]{"maxItems=2"}).withWorkflowAPI().usingTask(this.taskModel).getTaskFormModel();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)formModelsWithMaxItems.assertThat().entriesListContains("name", firstTaskFormModel.getName())).assertThat().entriesListContains("name", secondTaskFormModel.getName())).assertThat().entriesListCountIs(2);
        formModelsWithMaxItems.assertThat().paginationField("maxItems").is("2");
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify admin doesn't get task form model with negative maxItems parameter applied using REST API")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void getTaskFormModelWithNegativeMaxItems() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.userModel);
        this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"maxItems=-1"}).withWorkflowAPI().usingTask(this.taskModel).getTaskFormModel();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS).containsErrorKey(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE).statusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify admin doesn't get task form model with non numeric maxItems parameter applied using REST API")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void getTaskFormModelWithNonNumericMaxItems() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.userModel);
        this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"maxItems=A"}).withWorkflowAPI().usingTask(this.taskModel).getTaskFormModel();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_MAXITEMS, "A"));
    }
}

