/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.core.swagger;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import io.swagger.models.Operation;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;

public class SwaggerRequest {
    private Configuration cfg;
    private Operation swaggerRequest;
    private String httpMethod;
    private String pathUrl;

    private Configuration getConfig() {
        if (this.cfg == null) {
            this.cfg = new Configuration(Configuration.VERSION_2_3_23);
            try {
                this.cfg.setDirectoryForTemplateLoading(new File("src/main/resources"));
            }
            catch (IOException e) {
                throw new IllegalStateException("Exception while configuring Freemarker template directory.", e);
            }
        }
        return this.cfg;
    }

    public SwaggerRequest(String httpMethod, String pathUrl, Operation swaggerRequest) {
        this.swaggerRequest = swaggerRequest;
        this.httpMethod = httpMethod;
        this.pathUrl = pathUrl;
    }

    public String getRequestSample() {
        try {
            Template template = this.getConfig().getTemplate("rest-request.ftl");
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("operationId", this.swaggerRequest.getOperationId());
            data.put("httpMethod", this.httpMethod);
            data.put("pathUrl", this.pathUrl);
            StringWriter append = new StringWriter();
            template.process(data, (Writer)append);
            ((Writer)append).close();
            return ((Object)append).toString();
        }
        catch (TemplateException | IOException e) {
            throw new IllegalStateException("Exception while loading sample request.", e);
        }
    }
}

