/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.model.builder;

import java.util.LinkedList;
import java.util.List;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestNodeBodyModel;
import org.alfresco.rest.model.RestNodeModel;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.RepoTestModel;

public class NodesBuilder {
    private List<NodeDetail> nodes = new LinkedList<NodeDetail>();
    private RestWrapper restWrapper;
    private RepoTestModel lastNode;

    public NodeDetail getNode(String prefix) {
        for (NodeDetail node : this.nodes) {
            if (!node.getPrefix().equals(prefix)) continue;
            return node;
        }
        return null;
    }

    public NodesBuilder(RestWrapper restWrapper, RepoTestModel repoModel) {
        this.restWrapper = restWrapper;
        this.lastNode = repoModel;
    }

    public NodeDetail folder(String prefix) {
        NodeDetail n = new NodeDetail(prefix, this.lastNode.getNodeRef(), "cm:folder");
        this.nodes.add(n);
        return n;
    }

    public class NodeDetail {
        private RestNodeModel parentNodeModel;
        private String id;
        private String prefix;
        private String name;

        public ContentModel toContentModel() {
            ContentModel cm = new ContentModel();
            cm.setNodeRef(this.getId());
            return cm;
        }

        public NodeDetail(String prefix, String parentId, String nodeType) {
            this.prefix = prefix;
            this.name = RandomData.getRandomName((String)prefix);
            RestNodeBodyModel model = new RestNodeBodyModel();
            model.setName(this.name);
            model.setNodeType(nodeType);
            ContentModel parent = new ContentModel();
            parent.setNodeRef(parentId);
            RestNodeModel newModel = NodesBuilder.this.restWrapper.withCoreAPI().usingNode((RepoTestModel)parent).createNode(model);
            this.id = newModel.getId();
            if (nodeType.equals("cm:content")) {
                RestNodeModel tmp = new RestNodeModel();
                tmp.setId(parentId);
                this.parentNodeModel = tmp;
            } else {
                this.parentNodeModel = newModel;
            }
        }

        public NodeDetail folder(String prefix) {
            NodeDetail n = new NodeDetail(prefix, this.parentNodeModel.getId(), "cm:folder");
            NodesBuilder.this.nodes.add(n);
            return n;
        }

        public NodeDetail file(String prefix) {
            NodeDetail n = new NodeDetail(prefix, this.parentNodeModel.getId(), "cm:content");
            NodesBuilder.this.nodes.add(n);
            return n;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

