/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.repo.resource.category;

import java.util.Map;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestCategoryModel;
import org.alfresco.rest.repo.resource.category.RepoCategoryCreator;
import org.alfresco.rest.repo.resource.general.Modifier;
import org.alfresco.rest.repo.resource.general.ResourceModifier;
import org.alfresco.rest.repo.resource.general.Specifier;
import org.alfresco.rest.requests.Categories;
import org.alfresco.utility.model.UserModel;

public class RepoCategoryModifier
extends ResourceModifier<RestCategoryModel, Modifier.CategoryModifier>
implements Modifier.CategoryModifier {
    private final RestWrapper restClient;
    private final RestCategoryModel category;
    private final Map<String, RestCategoryModel> categoriesCache;

    public RepoCategoryModifier(RestWrapper restClient, RestCategoryModel category, Map<String, RestCategoryModel> categoriesCache) {
        this.restClient = restClient;
        this.category = category;
        this.categoriesCache = categoriesCache;
    }

    @Override
    protected Modifier.CategoryModifier self() {
        return this;
    }

    @Override
    public Specifier.CategoriesSpecifier add() {
        return (Specifier.CategoriesSpecifier)new RepoCategoryCreator(this.restClient, this.categoriesCache).underCategory(this.category).asUser(this.user);
    }

    @Override
    public RestCategoryModel get(String id) {
        return RepoCategoryModifier.buildCategoryRestRequest(this.restClient, this.user, RestCategoryModel.builder().id(id).create()).getCategory();
    }

    @Override
    public void delete() {
        this.categoriesCache.remove(this.category.getId());
        RepoCategoryModifier.buildCategoryRestRequest(this.restClient, this.user, this.category).deleteCategory();
    }

    private static Categories buildCategoryRestRequest(RestWrapper restClient, UserModel user, RestCategoryModel category) {
        return restClient.authenticateUser(user).withCoreAPI().usingCategory(category);
    }
}

