/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.repo.resource.general;

import java.util.random.RandomGenerator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.alfresco.rest.model.RestCategoryModel;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.TestModel;
import org.alfresco.utility.model.UserModel;
import org.apache.commons.lang3.RandomStringUtils;

public interface Creator<RESOURCE extends TestModel, SELF extends Creator<RESOURCE, ?>> {
    public SELF withName(String var1);

    public <USER extends UserModel> SELF asUser(USER var1);

    public RESOURCE create();

    public static interface CategoryCreator
    extends Creator<RestCategoryModel, CategoryCreator> {
        public <CATEGORY extends RestCategoryModel> CategoryCreator underCategory(CATEGORY var1);
    }

    public static interface FileCreator
    extends ContentCreator<FileModel, FileCreator> {
        public FileCreator ofType(FileType var1);

        public FileCreator withContent(String var1);

        default public FileCreator withRandomContent() {
            return this.withRandomContent(RandomGenerator.getDefault().nextInt(30, 70), 10);
        }

        default public FileCreator withRandomContent(int wordsNumber, int wordsMaxLength) {
            return this.withContent(IntStream.range(0, wordsNumber).mapToObj(i -> RandomStringUtils.randomAlphanumeric((int)1, (int)wordsMaxLength)).collect(Collectors.joining(" ")));
        }
    }

    public static interface FolderCreator
    extends ContentCreator<FolderModel, FolderCreator> {
    }

    public static interface ContentCreator<CONTENT extends ContentModel, SELF extends ContentCreator<CONTENT, ?>>
    extends Creator<CONTENT, SELF> {
        public SELF withTitle(String var1);

        default public SELF withRandomTitle() {
            return this.withTitle(RandomStringUtils.randomAlphanumeric((int)10));
        }

        public SELF withDescription(String var1);

        default public SELF withRandomDescription() {
            return this.withDescription(RandomStringUtils.randomAlphanumeric((int)20));
        }

        public <FOLDER extends FolderModel> SELF underFolder(FOLDER var1);

        public <SITE extends SiteModel> SELF withinSite(SITE var1);
    }
}

