/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.people.preferences;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestPreferenceModelsCollection;
import org.alfresco.rest.requests.People;
import org.alfresco.utility.constants.PreferenceName;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetPeoplePreferencesCoreTests
extends RestTest {
    UserModel userModel;
    UserModel user1;
    UserModel user2;
    UserModel adminUser;
    SiteModel siteModel;
    FolderModel folderModel;
    private RestPreferenceModelsCollection restPreferenceModelsCollection;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userModel = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        this.user1 = this.dataUser.createRandomTestUser();
        ((DataSite)((DataSite)this.dataSite.usingUser(this.user1)).usingSite(this.siteModel)).addSiteToFavorites();
        ((DataContent)this.dataContent.usingUser(this.user1).usingSite(this.siteModel)).addFolderToFavorites(this.folderModel);
    }

    @Test(groups={"rest-api", "people", "preferences", "regression"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets its preferences with invalid maxItems parameter with Rest API and response is 400")
    public void userGetsPeoplePreferencesUsingInvalidMaxItemsParameter() throws Exception {
        this.restPreferenceModelsCollection = ((People)this.restClient.authenticateUser(this.user1).withCoreAPI().usingMe().usingParams(new String[]{"maxItems=0"})).getPersonPreferences();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS).containsSummary(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS).stackTraceIs(RestErrorModel.STACKTRACE).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
    }

    @Test(groups={"rest-api", "people", "preferences", "regression"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets its preferences with skipCount parameter applied with Rest API and response is successful")
    public void userGetsPeoplePreferencesUsingInvalidSkipCountParameter() throws Exception {
        this.restPreferenceModelsCollection = ((People)this.restClient.authenticateUser(this.user1).withCoreAPI().usingMe().usingParams(new String[]{"skipCount=-1"})).getPersonPreferences();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(RestErrorModel.NEGATIVE_VALUES_SKIPCOUNT).containsSummary(RestErrorModel.NEGATIVE_VALUES_SKIPCOUNT).stackTraceIs(RestErrorModel.STACKTRACE).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
    }

    @Test(groups={"rest-api", "people", "preferences", "regression"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.REGRESSION}, description="Verify user which doesn't have access to another user preferences fails to get its preferences with Rest API and response is permission denied")
    public void userWithNoAccessToOtherUserPreferencesIsForbiddenToGetItsPreferences() throws Exception {
        UserModel noAccessUser = this.dataUser.createRandomTestUser();
        ((DataSite)((DataSite)this.dataSite.usingUser(noAccessUser)).usingSite(this.siteModel)).addSiteToFavorites();
        this.restPreferenceModelsCollection = this.restClient.authenticateUser(this.user1).withCoreAPI().usingUser(noAccessUser).getPersonPreferences();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
        this.restClient.assertLastError().containsErrorKey(RestErrorModel.PERMISSION_DENIED_ERRORKEY).containsSummary(RestErrorModel.PERMISSION_WAS_DENIED).stackTraceIs(RestErrorModel.STACKTRACE).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
    }

    @Test(groups={"rest-api", "people", "preferences", "regression"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.REGRESSION}, description="Verify user fails to get preferences for inexistent personId with Rest API and response is 404")
    public void userCannotGetPeoplePreferencesForInexistentPersonId() throws Exception {
        UserModel inexistentUserName = new UserModel("inexistent", "password");
        this.restPreferenceModelsCollection = this.restClient.authenticateUser(this.user1).withCoreAPI().usingUser(inexistentUserName).getPersonPreferences();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
        this.restClient.assertLastError().containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, inexistentUserName.getUsername())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "people", "preferences", "regression"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.REGRESSION}, description="Verify user get preferences for a user with no preferences with Rest API and response is empty")
    public void userGetsPeoplePreferencesForUserWithNoPreferences() throws Exception {
        UserModel userNoActivities = this.dataUser.createRandomTestUser();
        this.restPreferenceModelsCollection = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingUser(userNoActivities).getPersonPreferences();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restPreferenceModelsCollection.assertThat().paginationField("count").is("0");
        this.restPreferenceModelsCollection.assertThat().entriesListIsEmpty();
    }

    @Test(groups={"rest-api", "people", "preferences", "regression"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.REGRESSION}, description="Verify user fails to get preferences for a removed preference with Rest API and response is 404")
    public void userFailsToGetPeoplePreferencesIfPreferenceWasRemoved() throws Exception {
        SiteModel preferenceSite = ((DataSite)this.dataSite.usingUser(this.user1)).createPublicRandomSite();
        ((DataSite)((DataSite)this.dataSite.usingUser(this.user1)).usingSite(preferenceSite)).addSiteToFavorites();
        this.restPreferenceModelsCollection = this.restClient.authenticateUser(this.user1).withCoreAPI().usingAuthUser().getPersonPreferences();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restPreferenceModelsCollection.assertThat().paginationField("count").is("6");
        ((DataSite)((DataSite)this.dataSite.usingUser(this.user1)).usingSite(preferenceSite)).removeSiteFromFavorites();
        this.restPreferenceModelsCollection = this.restClient.authenticateUser(this.user1).withCoreAPI().usingAuthUser().getPersonPreferences();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restPreferenceModelsCollection.assertThat().paginationField("count").is("5");
        this.restPreferenceModelsCollection.assertThat().entriesListDoesNotContain("id", String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), preferenceSite.getId()));
    }
}

