/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ar;

import java.io.IOException;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.ar.ArabicAnalyzer;
import org.apache.lucene.util.Version;

public class TestArabicAnalyzer
extends BaseTokenStreamTestCase {
    public void testResourcesAvailable() {
        new ArabicAnalyzer().close();
    }

    public void testBasicFeatures() throws Exception {
        ArabicAnalyzer a = new ArabicAnalyzer();
        TestArabicAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0643\u0628\u064a\u0631", (String[])new String[]{"\u0643\u0628\u064a\u0631"});
        TestArabicAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0643\u0628\u064a\u0631\u0629", (String[])new String[]{"\u0643\u0628\u064a\u0631"});
        TestArabicAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0645\u0634\u0631\u0648\u0628", (String[])new String[]{"\u0645\u0634\u0631\u0648\u0628"});
        TestArabicAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0645\u0634\u0631\u0648\u0628\u0627\u062a", (String[])new String[]{"\u0645\u0634\u0631\u0648\u0628"});
        TestArabicAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0623\u0645\u0631\u064a\u0643\u064a\u064a\u0646", (String[])new String[]{"\u0627\u0645\u0631\u064a\u0643"});
        TestArabicAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0627\u0645\u0631\u064a\u0643\u064a", (String[])new String[]{"\u0627\u0645\u0631\u064a\u0643"});
        TestArabicAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0643\u062a\u0627\u0628", (String[])new String[]{"\u0643\u062a\u0627\u0628"});
        TestArabicAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0627\u0644\u0643\u062a\u0627\u0628", (String[])new String[]{"\u0643\u062a\u0627\u0628"});
        TestArabicAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0645\u0627 \u0645\u0644\u0643\u062a \u0623\u064a\u0645\u0627\u0646\u0643\u0645", (String[])new String[]{"\u0645\u0644\u0643\u062a", "\u0627\u064a\u0645\u0627\u0646\u0643\u0645"});
        TestArabicAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0627\u0644\u0630\u064a\u0646 \u0645\u0644\u0643\u062a \u0623\u064a\u0645\u0627\u0646\u0643\u0645", (String[])new String[]{"\u0645\u0644\u0643\u062a", "\u0627\u064a\u0645\u0627\u0646\u0643\u0645"});
        a.close();
    }

    public void testReusableTokenStream() throws Exception {
        ArabicAnalyzer a = new ArabicAnalyzer();
        TestArabicAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0643\u0628\u064a\u0631", (String[])new String[]{"\u0643\u0628\u064a\u0631"});
        TestArabicAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0643\u0628\u064a\u0631\u0629", (String[])new String[]{"\u0643\u0628\u064a\u0631"});
        a.close();
    }

    public void testEnglishInput() throws Exception {
        ArabicAnalyzer a = new ArabicAnalyzer();
        TestArabicAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"English text.", (String[])new String[]{"english", "text"});
        a.close();
    }

    public void testCustomStopwords() throws Exception {
        CharArraySet set = new CharArraySet((Collection)TestArabicAnalyzer.asSet((Object[])new String[]{"the", "and", "a"}), false);
        ArabicAnalyzer a = new ArabicAnalyzer(set);
        TestArabicAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"The quick brown fox.", (String[])new String[]{"quick", "brown", "fox"});
        a.close();
    }

    public void testWithStemExclusionSet() throws IOException {
        CharArraySet set = new CharArraySet((Collection)TestArabicAnalyzer.asSet((Object[])new String[]{"\u0633\u0627\u0647\u062f\u0647\u0627\u062a"}), false);
        ArabicAnalyzer a = new ArabicAnalyzer(CharArraySet.EMPTY_SET, set);
        TestArabicAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0643\u0628\u064a\u0631\u0629 the quick \u0633\u0627\u0647\u062f\u0647\u0627\u062a", (String[])new String[]{"\u0643\u0628\u064a\u0631", "the", "quick", "\u0633\u0627\u0647\u062f\u0647\u0627\u062a"});
        TestArabicAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0643\u0628\u064a\u0631\u0629 the quick \u0633\u0627\u0647\u062f\u0647\u0627\u062a", (String[])new String[]{"\u0643\u0628\u064a\u0631", "the", "quick", "\u0633\u0627\u0647\u062f\u0647\u0627\u062a"});
        a.close();
        a = new ArabicAnalyzer(CharArraySet.EMPTY_SET, CharArraySet.EMPTY_SET);
        TestArabicAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0643\u0628\u064a\u0631\u0629 the quick \u0633\u0627\u0647\u062f\u0647\u0627\u062a", (String[])new String[]{"\u0643\u0628\u064a\u0631", "the", "quick", "\u0633\u0627\u0647\u062f"});
        TestArabicAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0643\u0628\u064a\u0631\u0629 the quick \u0633\u0627\u0647\u062f\u0647\u0627\u062a", (String[])new String[]{"\u0643\u0628\u064a\u0631", "the", "quick", "\u0633\u0627\u0647\u062f"});
        a.close();
    }

    public void testDigits() throws Exception {
        ArabicAnalyzer a = new ArabicAnalyzer();
        TestArabicAnalyzer.checkOneTerm((Analyzer)a, (String)"\u0661\u0662\u0663\u0664", (String)"1234");
        a.close();
    }

    @Deprecated
    public void testDigitsBackCompat() throws Exception {
        ArabicAnalyzer a = new ArabicAnalyzer();
        a.setVersion(Version.LUCENE_5_3_0);
        TestArabicAnalyzer.checkOneTerm((Analyzer)a, (String)"\u0661\u0662\u0663\u0664", (String)"\u0661\u0662\u0663\u0664");
        a.close();
    }

    public void testRandomStrings() throws Exception {
        ArabicAnalyzer a = new ArabicAnalyzer();
        TestArabicAnalyzer.checkRandomData((Random)TestArabicAnalyzer.random(), (Analyzer)a, (int)(1000 * RANDOM_MULTIPLIER));
        a.close();
    }
}

