/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ar;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestArabicFilters
extends BaseTokenStreamFactoryTestCase {
    public void testNormalizer() throws Exception {
        StringReader reader = new StringReader("\u0627\u0644\u0630\u064a\u0646 \u0645\u064e\u0644\u0643\u062a \u0623\u064a\u0645\u0627\u0646\u0643\u0645");
        MockTokenizer tokenizer = TestArabicFilters.whitespaceMockTokenizer((Reader)reader);
        TokenStream stream = this.tokenFilterFactory("ArabicNormalization", new String[0]).create((TokenStream)tokenizer);
        TestArabicFilters.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"\u0627\u0644\u0630\u064a\u0646", "\u0645\u0644\u0643\u062a", "\u0627\u064a\u0645\u0627\u0646\u0643\u0645"});
    }

    public void testStemmer() throws Exception {
        StringReader reader = new StringReader("\u0627\u0644\u0630\u064a\u0646 \u0645\u064e\u0644\u0643\u062a \u0623\u064a\u0645\u0627\u0646\u0643\u0645");
        MockTokenizer tokenizer = TestArabicFilters.whitespaceMockTokenizer((Reader)reader);
        TokenStream stream = this.tokenFilterFactory("ArabicNormalization", new String[0]).create((TokenStream)tokenizer);
        stream = this.tokenFilterFactory("ArabicStem", new String[0]).create(stream);
        TestArabicFilters.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"\u0630\u064a\u0646", "\u0645\u0644\u0643\u062a", "\u0627\u064a\u0645\u0627\u0646\u0643\u0645"});
    }

    public void testPersianCharFilter() throws Exception {
        Reader reader = this.charFilterFactory("Persian", new String[0]).create((Reader)new StringReader("\u0645\u06cc\u200c\u062e\u0648\u0631\u062f"));
        MockTokenizer tokenizer = TestArabicFilters.whitespaceMockTokenizer((Reader)reader);
        TestArabicFilters.assertTokenStreamContents((TokenStream)tokenizer, (String[])new String[]{"\u0645\u06cc", "\u062e\u0648\u0631\u062f"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestArabicFilters.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("ArabicNormalization", "bogusArg", "bogusValue"));
        TestArabicFilters.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
        expected = (IllegalArgumentException)TestArabicFilters.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("Arabicstem", "bogusArg", "bogusValue"));
        TestArabicFilters.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
        expected = (IllegalArgumentException)TestArabicFilters.expectThrows(IllegalArgumentException.class, () -> this.charFilterFactory("Persian", "bogusArg", "bogusValue"));
        TestArabicFilters.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

