/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ar;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ar.ArabicNormalizationFilter;
import org.apache.lucene.analysis.core.KeywordTokenizer;

public class TestArabicNormalizationFilter
extends BaseTokenStreamTestCase {
    public void testAlifMadda() throws IOException {
        this.check("\u0622\u062c\u0646", "\u0627\u062c\u0646");
    }

    public void testAlifHamzaAbove() throws IOException {
        this.check("\u0623\u062d\u0645\u062f", "\u0627\u062d\u0645\u062f");
    }

    public void testAlifHamzaBelow() throws IOException {
        this.check("\u0625\u0639\u0627\u0630", "\u0627\u0639\u0627\u0630");
    }

    public void testAlifMaksura() throws IOException {
        this.check("\u0628\u0646\u0649", "\u0628\u0646\u064a");
    }

    public void testTehMarbuta() throws IOException {
        this.check("\u0641\u0627\u0637\u0645\u0629", "\u0641\u0627\u0637\u0645\u0647");
    }

    public void testTatweel() throws IOException {
        this.check("\u0631\u0648\u0628\u0631\u0640\u0640\u0640\u0640\u0640\u062a", "\u0631\u0648\u0628\u0631\u062a");
    }

    public void testFatha() throws IOException {
        this.check("\u0645\u064e\u0628\u0646\u0627", "\u0645\u0628\u0646\u0627");
    }

    public void testKasra() throws IOException {
        this.check("\u0639\u0644\u0650\u064a", "\u0639\u0644\u064a");
    }

    public void testDamma() throws IOException {
        this.check("\u0628\u064f\u0648\u0627\u062a", "\u0628\u0648\u0627\u062a");
    }

    public void testFathatan() throws IOException {
        this.check("\u0648\u0644\u062f\u0627\u064b", "\u0648\u0644\u062f\u0627");
    }

    public void testKasratan() throws IOException {
        this.check("\u0648\u0644\u062f\u064d", "\u0648\u0644\u062f");
    }

    public void testDammatan() throws IOException {
        this.check("\u0648\u0644\u062f\u064c", "\u0648\u0644\u062f");
    }

    public void testSukun() throws IOException {
        this.check("\u0646\u0644\u0652\u0633\u0648\u0646", "\u0646\u0644\u0633\u0648\u0646");
    }

    public void testShaddah() throws IOException {
        this.check("\u0647\u062a\u0645\u064a\u0651", "\u0647\u062a\u0645\u064a");
    }

    private void check(String input, String expected) throws IOException {
        MockTokenizer tokenStream = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        tokenStream.setReader((Reader)new StringReader(input));
        ArabicNormalizationFilter filter = new ArabicNormalizationFilter((TokenStream)tokenStream);
        TestArabicNormalizationFilter.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{expected});
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new ArabicNormalizationFilter((TokenStream)tokenizer));
            }
        };
        TestArabicNormalizationFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

