/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ar;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ar.ArabicStemFilter;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;

public class TestArabicStemFilter
extends BaseTokenStreamTestCase {
    public void testAlPrefix() throws IOException {
        this.check("\u0627\u0644\u062d\u0633\u0646", "\u062d\u0633\u0646");
    }

    public void testWalPrefix() throws IOException {
        this.check("\u0648\u0627\u0644\u062d\u0633\u0646", "\u062d\u0633\u0646");
    }

    public void testBalPrefix() throws IOException {
        this.check("\u0628\u0627\u0644\u062d\u0633\u0646", "\u062d\u0633\u0646");
    }

    public void testKalPrefix() throws IOException {
        this.check("\u0643\u0627\u0644\u062d\u0633\u0646", "\u062d\u0633\u0646");
    }

    public void testFalPrefix() throws IOException {
        this.check("\u0641\u0627\u0644\u062d\u0633\u0646", "\u062d\u0633\u0646");
    }

    public void testLlPrefix() throws IOException {
        this.check("\u0644\u0644\u0627\u062e\u0631", "\u0627\u062e\u0631");
    }

    public void testWaPrefix() throws IOException {
        this.check("\u0648\u062d\u0633\u0646", "\u062d\u0633\u0646");
    }

    public void testAhSuffix() throws IOException {
        this.check("\u0632\u0648\u062c\u0647\u0627", "\u0632\u0648\u062c");
    }

    public void testAnSuffix() throws IOException {
        this.check("\u0633\u0627\u0647\u062f\u0627\u0646", "\u0633\u0627\u0647\u062f");
    }

    public void testAtSuffix() throws IOException {
        this.check("\u0633\u0627\u0647\u062f\u0627\u062a", "\u0633\u0627\u0647\u062f");
    }

    public void testWnSuffix() throws IOException {
        this.check("\u0633\u0627\u0647\u062f\u0648\u0646", "\u0633\u0627\u0647\u062f");
    }

    public void testYnSuffix() throws IOException {
        this.check("\u0633\u0627\u0647\u062f\u064a\u0646", "\u0633\u0627\u0647\u062f");
    }

    public void testYhSuffix() throws IOException {
        this.check("\u0633\u0627\u0647\u062f\u064a\u0647", "\u0633\u0627\u0647\u062f");
    }

    public void testYpSuffix() throws IOException {
        this.check("\u0633\u0627\u0647\u062f\u064a\u0629", "\u0633\u0627\u0647\u062f");
    }

    public void testHSuffix() throws IOException {
        this.check("\u0633\u0627\u0647\u062f\u0647", "\u0633\u0627\u0647\u062f");
    }

    public void testPSuffix() throws IOException {
        this.check("\u0633\u0627\u0647\u062f\u0629", "\u0633\u0627\u0647\u062f");
    }

    public void testYSuffix() throws IOException {
        this.check("\u0633\u0627\u0647\u062f\u064a", "\u0633\u0627\u0647\u062f");
    }

    public void testComboPrefSuf() throws IOException {
        this.check("\u0648\u0633\u0627\u0647\u062f\u0648\u0646", "\u0633\u0627\u0647\u062f");
    }

    public void testComboSuf() throws IOException {
        this.check("\u0633\u0627\u0647\u062f\u0647\u0627\u062a", "\u0633\u0627\u0647\u062f");
    }

    public void testShouldntStem() throws IOException {
        this.check("\u0627\u0644\u0648", "\u0627\u0644\u0648");
    }

    public void testNonArabic() throws IOException {
        this.check("English", "English");
    }

    public void testWithKeywordAttribute() throws IOException {
        CharArraySet set = new CharArraySet(1, true);
        set.add("\u0633\u0627\u0647\u062f\u0647\u0627\u062a");
        MockTokenizer tokenStream = TestArabicStemFilter.whitespaceMockTokenizer((String)"\u0633\u0627\u0647\u062f\u0647\u0627\u062a");
        ArabicStemFilter filter = new ArabicStemFilter((TokenStream)new SetKeywordMarkerFilter((TokenStream)tokenStream, set));
        TestArabicStemFilter.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"\u0633\u0627\u0647\u062f\u0647\u0627\u062a"});
    }

    private void check(String input, String expected) throws IOException {
        MockTokenizer tokenStream = TestArabicStemFilter.whitespaceMockTokenizer((String)input);
        ArabicStemFilter filter = new ArabicStemFilter((TokenStream)tokenStream);
        TestArabicStemFilter.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{expected});
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new ArabicStemFilter((TokenStream)tokenizer));
            }
        };
        TestArabicStemFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

