/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.bg;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.bg.BulgarianAnalyzer;

public class TestBulgarianAnalyzer
extends BaseTokenStreamTestCase {
    public void testResourcesAvailable() {
        new BulgarianAnalyzer().close();
    }

    public void testStopwords() throws IOException {
        BulgarianAnalyzer a = new BulgarianAnalyzer();
        TestBulgarianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u041a\u0430\u043a \u0441\u0435 \u043a\u0430\u0437\u0432\u0430\u0448?", (String[])new String[]{"\u043a\u0430\u0437\u0432\u0430\u0448"});
        a.close();
    }

    public void testCustomStopwords() throws IOException {
        BulgarianAnalyzer a = new BulgarianAnalyzer(CharArraySet.EMPTY_SET);
        TestBulgarianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u041a\u0430\u043a \u0441\u0435 \u043a\u0430\u0437\u0432\u0430\u0448?", (String[])new String[]{"\u043a\u0430\u043a", "\u0441\u0435", "\u043a\u0430\u0437\u0432\u0430\u0448"});
        a.close();
    }

    public void testReusableTokenStream() throws IOException {
        BulgarianAnalyzer a = new BulgarianAnalyzer();
        TestBulgarianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0438", (String[])new String[]{"\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442"});
        TestBulgarianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442", (String[])new String[]{"\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442"});
        a.close();
    }

    public void testBasicExamples() throws IOException {
        BulgarianAnalyzer a = new BulgarianAnalyzer();
        TestBulgarianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0435\u043d\u0435\u0440\u0433\u0438\u0439\u043d\u0438 \u043a\u0440\u0438\u0437\u0438", (String[])new String[]{"\u0435\u043d\u0435\u0440\u0433\u0438\u0439\u043d", "\u043a\u0440\u0438\u0437"});
        TestBulgarianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0410\u0442\u043e\u043c\u043d\u0430\u0442\u0430 \u0435\u043d\u0435\u0440\u0433\u0438\u044f", (String[])new String[]{"\u0430\u0442\u043e\u043c\u043d", "\u0435\u043d\u0435\u0440\u0433"});
        TestBulgarianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u043a\u043e\u043c\u043f\u044e\u0442\u0440\u0438", (String[])new String[]{"\u043a\u043e\u043c\u043f\u044e\u0442\u0440"});
        TestBulgarianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u043a\u043e\u043c\u043f\u044e\u0442\u044a\u0440", (String[])new String[]{"\u043a\u043e\u043c\u043f\u044e\u0442\u0440"});
        TestBulgarianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0433\u0440\u0430\u0434\u043e\u0432\u0435", (String[])new String[]{"\u0433\u0440\u0430\u0434"});
        a.close();
    }

    public void testWithStemExclusionSet() throws IOException {
        CharArraySet set = new CharArraySet(1, true);
        set.add("\u0441\u0442\u0440\u043e\u0435\u0432\u0435");
        BulgarianAnalyzer a = new BulgarianAnalyzer(CharArraySet.EMPTY_SET, set);
        TestBulgarianAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0441\u0442\u0440\u043e\u0435\u0432\u0435\u0442\u0435 \u0441\u0442\u0440\u043e\u0435\u0432\u0435", (String[])new String[]{"\u0441\u0442\u0440\u043e\u0439", "\u0441\u0442\u0440\u043e\u0435\u0432\u0435"});
        a.close();
    }

    public void testRandomStrings() throws Exception {
        BulgarianAnalyzer a = new BulgarianAnalyzer();
        TestBulgarianAnalyzer.checkRandomData((Random)TestBulgarianAnalyzer.random(), (Analyzer)a, (int)(1000 * RANDOM_MULTIPLIER));
        a.close();
    }
}

