/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.bg;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestBulgarianStemFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testStemming() throws Exception {
        StringReader reader = new StringReader("\u043a\u043e\u043c\u043f\u044e\u0442\u0440\u0438");
        MockTokenizer tokenizer = TestBulgarianStemFilterFactory.whitespaceMockTokenizer((Reader)reader);
        TokenStream stream = this.tokenFilterFactory("BulgarianStem", new String[0]).create((TokenStream)tokenizer);
        TestBulgarianStemFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"\u043a\u043e\u043c\u043f\u044e\u0442\u0440"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestBulgarianStemFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("BulgarianStem", "bogusArg", "bogusValue"));
        TestBulgarianStemFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

