/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.bg;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.bg.BulgarianAnalyzer;
import org.apache.lucene.analysis.bg.BulgarianStemFilter;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;

public class TestBulgarianStemmer
extends BaseTokenStreamTestCase {
    public void testMasculineNouns() throws IOException {
        BulgarianAnalyzer a = new BulgarianAnalyzer();
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0433\u0440\u0430\u0434", (String[])new String[]{"\u0433\u0440\u0430\u0434"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0433\u0440\u0430\u0434\u0430", (String[])new String[]{"\u0433\u0440\u0430\u0434"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0433\u0440\u0430\u0434\u044a\u0442", (String[])new String[]{"\u0433\u0440\u0430\u0434"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0433\u0440\u0430\u0434\u043e\u0432\u0435", (String[])new String[]{"\u0433\u0440\u0430\u0434"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0433\u0440\u0430\u0434\u043e\u0432\u0435\u0442\u0435", (String[])new String[]{"\u0433\u0440\u0430\u0434"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043d\u0430\u0440\u043e\u0434", (String[])new String[]{"\u043d\u0430\u0440\u043e\u0434"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043d\u0430\u0440\u043e\u0434\u0430", (String[])new String[]{"\u043d\u0430\u0440\u043e\u0434"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043d\u0430\u0440\u043e\u0434\u044a\u0442", (String[])new String[]{"\u043d\u0430\u0440\u043e\u0434"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043d\u0430\u0440\u043e\u0434\u0438", (String[])new String[]{"\u043d\u0430\u0440\u043e\u0434"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043d\u0430\u0440\u043e\u0434\u0438\u0442\u0435", (String[])new String[]{"\u043d\u0430\u0440\u043e\u0434"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043d\u0430\u0440\u043e\u0434\u0435", (String[])new String[]{"\u043d\u0430\u0440\u043e\u0434"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043f\u044a\u0442", (String[])new String[]{"\u043f\u044a\u0442"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043f\u044a\u0442\u044f", (String[])new String[]{"\u043f\u044a\u0442"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043f\u044a\u0442\u044f\u0442", (String[])new String[]{"\u043f\u044a\u0442"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043f\u044a\u0442\u0438\u0449\u0430", (String[])new String[]{"\u043f\u044a\u0442"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043f\u044a\u0442\u0438\u0449\u0430\u0442\u0430", (String[])new String[]{"\u043f\u044a\u0442"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0433\u0440\u0430\u0434\u0435\u0446", (String[])new String[]{"\u0433\u0440\u0430\u0434\u0435\u0446"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0433\u0440\u0430\u0434\u0435\u0446\u0430", (String[])new String[]{"\u0433\u0440\u0430\u0434\u0435\u0446"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0433\u0440\u0430\u0434\u0435\u0446\u044a\u0442", (String[])new String[]{"\u0433\u0440\u0430\u0434\u0435\u0446"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0433\u0440\u0430\u0434\u043e\u0432\u0446\u0435", (String[])new String[]{"\u0433\u0440\u0430\u0434\u043e\u0432\u0446"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0433\u0440\u0430\u0434\u043e\u0432\u0446\u0435\u0442\u0435", (String[])new String[]{"\u0433\u0440\u0430\u0434\u043e\u0432\u0446"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0434\u044f\u0434\u043e", (String[])new String[]{"\u0434\u044f\u0434"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0434\u044f\u0434\u043e\u0442\u043e", (String[])new String[]{"\u0434\u044f\u0434"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0434\u044f\u0434\u043e\u0432\u0446\u0438", (String[])new String[]{"\u0434\u044f\u0434"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0434\u044f\u0434\u043e\u0432\u0446\u0438\u0442\u0435", (String[])new String[]{"\u0434\u044f\u0434"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043c\u044a\u0436", (String[])new String[]{"\u043c\u044a\u0436"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043c\u044a\u0436\u0430", (String[])new String[]{"\u043c\u044a\u0436"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043c\u044a\u0436\u0435", (String[])new String[]{"\u043c\u044a\u0436"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043c\u044a\u0436\u0435\u0442\u0435", (String[])new String[]{"\u043c\u044a\u0436"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043c\u044a\u0436\u043e", (String[])new String[]{"\u043c\u044a\u0436"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043c\u044a\u0436\u044a\u0442", (String[])new String[]{"\u043c\u044a\u0436\u044a\u0442"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043a\u0440\u0430\u043a", (String[])new String[]{"\u043a\u0440\u0430\u043a"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043a\u0440\u0430\u043a\u0430", (String[])new String[]{"\u043a\u0440\u0430\u043a"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043a\u0440\u0430\u043a\u044a\u0442", (String[])new String[]{"\u043a\u0440\u0430\u043a"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043a\u0440\u0430\u043a\u0430\u0442\u0430", (String[])new String[]{"\u043a\u0440\u0430\u043a"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0431\u0440\u0430\u0442", (String[])new String[]{"\u0431\u0440\u0430\u0442"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0431\u0440\u0430\u0442\u0430", (String[])new String[]{"\u0431\u0440\u0430\u0442"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0431\u0440\u0430\u0442\u044a\u0442", (String[])new String[]{"\u0431\u0440\u0430\u0442"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0431\u0440\u0430\u0442\u044f", (String[])new String[]{"\u0431\u0440\u0430\u0442"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0431\u0440\u0430\u0442\u044f\u0442\u0430", (String[])new String[]{"\u0431\u0440\u0430\u0442"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0431\u0440\u0430\u0442\u0435", (String[])new String[]{"\u0431\u0440\u0430\u0442"});
        a.close();
    }

    public void testFeminineNouns() throws IOException {
        BulgarianAnalyzer a = new BulgarianAnalyzer();
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0432\u0435\u0441\u0442", (String[])new String[]{"\u0432\u0435\u0441\u0442"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0432\u0435\u0441\u0442\u0442\u0430", (String[])new String[]{"\u0432\u0435\u0441\u0442"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0432\u0435\u0441\u0442\u0438", (String[])new String[]{"\u0432\u0435\u0441\u0442"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0432\u0435\u0441\u0442\u0438\u0442\u0435", (String[])new String[]{"\u0432\u0435\u0441\u0442"});
        a.close();
    }

    public void testNeuterNouns() throws IOException {
        BulgarianAnalyzer a = new BulgarianAnalyzer();
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0434\u044a\u0440\u0432\u043e", (String[])new String[]{"\u0434\u044a\u0440\u0432"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0434\u044a\u0440\u0432\u043e\u0442\u043e", (String[])new String[]{"\u0434\u044a\u0440\u0432"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0434\u044a\u0440\u0432\u0430", (String[])new String[]{"\u0434\u044a\u0440\u0432"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0434\u044a\u0440\u0432\u0435\u0442\u0430", (String[])new String[]{"\u0434\u044a\u0440\u0432"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0434\u044a\u0440\u0432\u0430\u0442\u0430", (String[])new String[]{"\u0434\u044a\u0440\u0432"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0434\u044a\u0440\u0432\u0435\u0442\u0430\u0442\u0430", (String[])new String[]{"\u0434\u044a\u0440\u0432"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043c\u043e\u0440\u0435", (String[])new String[]{"\u043c\u043e\u0440"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043c\u043e\u0440\u0435\u0442\u043e", (String[])new String[]{"\u043c\u043e\u0440"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043c\u043e\u0440\u0435\u0442\u0430", (String[])new String[]{"\u043c\u043e\u0440"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043c\u043e\u0440\u0435\u0442\u0430\u0442\u0430", (String[])new String[]{"\u043c\u043e\u0440"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0438\u0437\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435", (String[])new String[]{"\u0438\u0437\u043a\u043b\u044e\u0447\u0435\u043d\u0438"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0438\u0437\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435\u0442\u043e", (String[])new String[]{"\u0438\u0437\u043a\u043b\u044e\u0447\u0435\u043d\u0438"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0438\u0437\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f\u0442\u0430", (String[])new String[]{"\u0438\u0437\u043a\u043b\u044e\u0447\u0435\u043d\u0438"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0438\u0437\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f", (String[])new String[]{"\u0438\u0437\u043a\u043b\u044e\u0447\u043d"});
        a.close();
    }

    public void testAdjectives() throws IOException {
        BulgarianAnalyzer a = new BulgarianAnalyzer();
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043a\u0440\u0430\u0441\u0438\u0432", (String[])new String[]{"\u043a\u0440\u0430\u0441\u0438\u0432"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043a\u0440\u0430\u0441\u0438\u0432\u0438\u044f", (String[])new String[]{"\u043a\u0440\u0430\u0441\u0438\u0432"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043a\u0440\u0430\u0441\u0438\u0432\u0438\u044f\u0442", (String[])new String[]{"\u043a\u0440\u0430\u0441\u0438\u0432"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043a\u0440\u0430\u0441\u0438\u0432\u0430", (String[])new String[]{"\u043a\u0440\u0430\u0441\u0438\u0432"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043a\u0440\u0430\u0441\u0438\u0432\u0430\u0442\u0430", (String[])new String[]{"\u043a\u0440\u0430\u0441\u0438\u0432"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043a\u0440\u0430\u0441\u0438\u0432\u043e", (String[])new String[]{"\u043a\u0440\u0430\u0441\u0438\u0432"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043a\u0440\u0430\u0441\u0438\u0432\u043e\u0442\u043e", (String[])new String[]{"\u043a\u0440\u0430\u0441\u0438\u0432"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043a\u0440\u0430\u0441\u0438\u0432\u0438", (String[])new String[]{"\u043a\u0440\u0430\u0441\u0438\u0432"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043a\u0440\u0430\u0441\u0438\u0432\u0438\u0442\u0435", (String[])new String[]{"\u043a\u0440\u0430\u0441\u0438\u0432"});
        a.close();
    }

    public void testExceptions() throws IOException {
        BulgarianAnalyzer a = new BulgarianAnalyzer();
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u0438\u043a", (String[])new String[]{"\u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u0438\u043a"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u0438\u043a\u0430", (String[])new String[]{"\u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u0438\u043a"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u0438\u043a\u044a\u0442", (String[])new String[]{"\u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u0438\u043a"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u0438\u0446\u0438", (String[])new String[]{"\u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u0438\u043a"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u0438\u0446\u0438\u0442\u0435", (String[])new String[]{"\u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u0438\u043a"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043f\u043e\u0434\u043b\u043e\u0433", (String[])new String[]{"\u043f\u043e\u0434\u043b\u043e\u0433"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043f\u043e\u0434\u043b\u043e\u0433\u0430", (String[])new String[]{"\u043f\u043e\u0434\u043b\u043e\u0433"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043f\u043e\u0434\u043b\u043e\u0433\u044a\u0442", (String[])new String[]{"\u043f\u043e\u0434\u043b\u043e\u0433"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043f\u043e\u0434\u043b\u043e\u0437\u0438", (String[])new String[]{"\u043f\u043e\u0434\u043b\u043e\u0433"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043f\u043e\u0434\u043b\u043e\u0437\u0438\u0442\u0435", (String[])new String[]{"\u043f\u043e\u0434\u043b\u043e\u0433"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043a\u043e\u0436\u0443\u0445", (String[])new String[]{"\u043a\u043e\u0436\u0443\u0445"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043a\u043e\u0436\u0443\u0445\u0430", (String[])new String[]{"\u043a\u043e\u0436\u0443\u0445"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043a\u043e\u0436\u0443\u0445\u044a\u0442", (String[])new String[]{"\u043a\u043e\u0436\u0443\u0445"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043a\u043e\u0436\u0443\u0441\u0438", (String[])new String[]{"\u043a\u043e\u0436\u0443\u0445"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043a\u043e\u0436\u0443\u0441\u0438\u0442\u0435", (String[])new String[]{"\u043a\u043e\u0436\u0443\u0445"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0446\u0435\u043d\u0442\u044a\u0440", (String[])new String[]{"\u0446\u0435\u043d\u0442\u0440"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0446\u0435\u043d\u0442\u044a\u0440\u0430", (String[])new String[]{"\u0446\u0435\u043d\u0442\u0440"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0446\u0435\u043d\u0442\u044a\u0440\u044a\u0442", (String[])new String[]{"\u0446\u0435\u043d\u0442\u0440"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0446\u0435\u043d\u0442\u0440\u043e\u0432\u0435", (String[])new String[]{"\u0446\u0435\u043d\u0442\u0440"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0446\u0435\u043d\u0442\u0440\u043e\u0432\u0435\u0442\u0435", (String[])new String[]{"\u0446\u0435\u043d\u0442\u0440"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043f\u0440\u043e\u043c\u044f\u043d\u0430", (String[])new String[]{"\u043f\u0440\u043e\u043c\u044f\u043d"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043f\u0440\u043e\u043c\u044f\u043d\u0430\u0442\u0430", (String[])new String[]{"\u043f\u0440\u043e\u043c\u044f\u043d"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043f\u0440\u043e\u043c\u0435\u043d\u0438", (String[])new String[]{"\u043f\u0440\u043e\u043c\u044f\u043d"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043f\u0440\u043e\u043c\u0435\u043d\u0438\u0442\u0435", (String[])new String[]{"\u043f\u0440\u043e\u043c\u044f\u043d"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043f\u0435\u0441\u0435\u043d", (String[])new String[]{"\u043f\u0435\u0441\u043d"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043f\u0435\u0441\u0435\u043d\u0442\u0430", (String[])new String[]{"\u043f\u0435\u0441\u043d"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043f\u0435\u0441\u043d\u0438", (String[])new String[]{"\u043f\u0435\u0441\u043d"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u043f\u0435\u0441\u043d\u0438\u0442\u0435", (String[])new String[]{"\u043f\u0435\u0441\u043d"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0441\u0442\u0440\u043e\u0439", (String[])new String[]{"\u0441\u0442\u0440\u043e\u0439"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0441\u0442\u0440\u043e\u0435\u0432\u0435", (String[])new String[]{"\u0441\u0442\u0440\u043e\u0439"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0441\u0442\u0440\u043e\u0435\u0432\u0435\u0442\u0435", (String[])new String[]{"\u0441\u0442\u0440\u043e\u0439"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0441\u0442\u0440\u043e\u044f", (String[])new String[]{"\u0441\u0442\u0440"});
        TestBulgarianStemmer.assertAnalyzesTo((Analyzer)a, (String)"\u0441\u0442\u0440\u043e\u044f\u0442", (String[])new String[]{"\u0441\u0442\u0440"});
        a.close();
    }

    public void testWithKeywordAttribute() throws IOException {
        CharArraySet set = new CharArraySet(1, true);
        set.add("\u0441\u0442\u0440\u043e\u0435\u0432\u0435");
        MockTokenizer tokenStream = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        tokenStream.setReader((Reader)new StringReader("\u0441\u0442\u0440\u043e\u0435\u0432\u0435\u0442\u0435 \u0441\u0442\u0440\u043e\u0435\u0432\u0435"));
        BulgarianStemFilter filter = new BulgarianStemFilter((TokenStream)new SetKeywordMarkerFilter((TokenStream)tokenStream, set));
        TestBulgarianStemmer.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"\u0441\u0442\u0440\u043e\u0439", "\u0441\u0442\u0440\u043e\u0435\u0432\u0435"});
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new BulgarianStemFilter((TokenStream)tokenizer));
            }
        };
        TestBulgarianStemmer.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

