/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.br;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.br.BrazilianAnalyzer;
import org.apache.lucene.analysis.br.BrazilianStemFilter;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.core.LowerCaseTokenizer;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;

public class TestBrazilianAnalyzer
extends BaseTokenStreamTestCase {
    public void testWithSnowballExamples() throws Exception {
        this.check("boa", "boa");
        this.check("boainain", "boainain");
        this.check("boas", "boas");
        this.check("b\u00f4as", "boas");
        this.check("boassu", "boassu");
        this.check("boataria", "boat");
        this.check("boate", "boat");
        this.check("boates", "boat");
        this.check("boatos", "boat");
        this.check("bob", "bob");
        this.check("boba", "bob");
        this.check("bobagem", "bobag");
        this.check("bobagens", "bobagens");
        this.check("bobalh\u00f5es", "bobalho");
        this.check("bobear", "bob");
        this.check("bobeira", "bobeir");
        this.check("bobinho", "bobinh");
        this.check("bobinhos", "bobinh");
        this.check("bobo", "bob");
        this.check("bobs", "bobs");
        this.check("boca", "boc");
        this.check("bocadas", "boc");
        this.check("bocadinho", "bocadinh");
        this.check("bocado", "boc");
        this.check("bocai\u00fava", "bocaiuv");
        this.check("bo\u00e7al", "bocal");
        this.check("bocarra", "bocarr");
        this.check("bocas", "boc");
        this.check("bode", "bod");
        this.check("bodoque", "bodoqu");
        this.check("body", "body");
        this.check("boeing", "boeing");
        this.check("boem", "boem");
        this.check("boemia", "boem");
        this.check("bo\u00eamio", "boemi");
        this.check("bogot\u00e1", "bogot");
        this.check("boi", "boi");
        this.check("b\u00f3ia", "boi");
        this.check("boiando", "boi");
        this.check("quiabo", "quiab");
        this.check("quicaram", "quic");
        this.check("quickly", "quickly");
        this.check("quieto", "quiet");
        this.check("quietos", "quiet");
        this.check("quilate", "quilat");
        this.check("quilates", "quilat");
        this.check("quilinhos", "quilinh");
        this.check("quilo", "quil");
        this.check("quilombo", "quilomb");
        this.check("quilom\u00e9tricas", "quilometr");
        this.check("quilom\u00e9tricos", "quilometr");
        this.check("quil\u00f4metro", "quilometr");
        this.check("quil\u00f4metros", "quilometr");
        this.check("quilos", "quil");
        this.check("quimica", "quimic");
        this.check("quilos", "quil");
        this.check("quimica", "quimic");
        this.check("quimicas", "quimic");
        this.check("quimico", "quimic");
        this.check("quimicos", "quimic");
        this.check("quimioterapia", "quimioterap");
        this.check("quimioter\u00e1picos", "quimioterap");
        this.check("quimono", "quimon");
        this.check("quincas", "quinc");
        this.check("quinh\u00e3o", "quinha");
        this.check("quinhentos", "quinhent");
        this.check("quinn", "quinn");
        this.check("quino", "quin");
        this.check("quinta", "quint");
        this.check("quintal", "quintal");
        this.check("quintana", "quintan");
        this.check("quintanilha", "quintanilh");
        this.check("quint\u00e3o", "quinta");
        this.check("quintess\u00eancia", "quintessente");
        this.check("quintino", "quintin");
        this.check("quinto", "quint");
        this.check("quintos", "quint");
        this.check("quintuplicou", "quintuplic");
        this.check("quinze", "quinz");
        this.check("quinzena", "quinzen");
        this.check("quiosque", "quiosqu");
    }

    public void testNormalization() throws Exception {
        this.check("Brasil", "brasil");
        this.check("Bras\u00edlia", "brasil");
        this.check("quimio5ter\u00e1picos", "quimio5terapicos");
        this.check("\u00e1\u00e1", "\u00e1\u00e1");
        this.check("\u00e1\u00e1\u00e1", "aaa");
    }

    public void testReusableTokenStream() throws Exception {
        BrazilianAnalyzer a = new BrazilianAnalyzer();
        this.checkReuse((Analyzer)a, "boa", "boa");
        this.checkReuse((Analyzer)a, "boainain", "boainain");
        this.checkReuse((Analyzer)a, "boas", "boas");
        this.checkReuse((Analyzer)a, "b\u00f4as", "boas");
        a.close();
    }

    public void testStemExclusionTable() throws Exception {
        BrazilianAnalyzer a = new BrazilianAnalyzer(CharArraySet.EMPTY_SET, new CharArraySet((Collection)TestBrazilianAnalyzer.asSet((Object[])new String[]{"quintess\u00eancia"}), false));
        this.checkReuse((Analyzer)a, "quintess\u00eancia", "quintess\u00eancia");
        a.close();
    }

    public void testWithKeywordAttribute() throws IOException {
        CharArraySet set = new CharArraySet(1, true);
        set.add("Bras\u00edlia");
        LowerCaseTokenizer tokenizer = new LowerCaseTokenizer();
        tokenizer.setReader((Reader)new StringReader("Bras\u00edlia Brasilia"));
        BrazilianStemFilter filter = new BrazilianStemFilter((TokenStream)new SetKeywordMarkerFilter((TokenStream)tokenizer, set));
        TestBrazilianAnalyzer.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"bras\u00edlia", "brasil"});
    }

    private void check(String input, String expected) throws Exception {
        BrazilianAnalyzer a = new BrazilianAnalyzer();
        TestBrazilianAnalyzer.checkOneTerm((Analyzer)a, (String)input, (String)expected);
        a.close();
    }

    private void checkReuse(Analyzer a, String input, String expected) throws Exception {
        TestBrazilianAnalyzer.checkOneTerm((Analyzer)a, (String)input, (String)expected);
    }

    public void testRandomStrings() throws Exception {
        BrazilianAnalyzer a = new BrazilianAnalyzer();
        TestBrazilianAnalyzer.checkRandomData((Random)TestBrazilianAnalyzer.random(), (Analyzer)a, (int)(1000 * RANDOM_MULTIPLIER));
        a.close();
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new BrazilianStemFilter((TokenStream)tokenizer));
            }
        };
        TestBrazilianAnalyzer.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

