/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.br;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestBrazilianStemFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testStemming() throws Exception {
        StringReader reader = new StringReader("Bras\u00edlia");
        MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        tokenizer.setReader((Reader)reader);
        TokenStream stream = this.tokenFilterFactory("BrazilianStem", new String[0]).create((TokenStream)tokenizer);
        TestBrazilianStemFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"brasil"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestBrazilianStemFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("BrazilianStem", "bogusArg", "bogusValue"));
        TestBrazilianStemFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

