/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ca;

import java.io.IOException;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.ca.CatalanAnalyzer;

public class TestCatalanAnalyzer
extends BaseTokenStreamTestCase {
    public void testResourcesAvailable() {
        new CatalanAnalyzer().close();
    }

    public void testBasics() throws IOException {
        CatalanAnalyzer a = new CatalanAnalyzer();
        TestCatalanAnalyzer.checkOneTerm((Analyzer)a, (String)"lleng\u00fces", (String)"llengu");
        TestCatalanAnalyzer.checkOneTerm((Analyzer)a, (String)"llengua", (String)"llengu");
        TestCatalanAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"un", (String[])new String[0]);
        a.close();
    }

    public void testContractions() throws IOException {
        CatalanAnalyzer a = new CatalanAnalyzer();
        TestCatalanAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"Diccionari de l'Institut d'Estudis Catalans", (String[])new String[]{"diccion", "inst", "estud", "catalan"});
        a.close();
    }

    public void testExclude() throws IOException {
        CharArraySet exclusionSet = new CharArraySet((Collection)TestCatalanAnalyzer.asSet((Object[])new String[]{"lleng\u00fces"}), false);
        CatalanAnalyzer a = new CatalanAnalyzer(CatalanAnalyzer.getDefaultStopSet(), exclusionSet);
        TestCatalanAnalyzer.checkOneTerm((Analyzer)a, (String)"lleng\u00fces", (String)"lleng\u00fces");
        TestCatalanAnalyzer.checkOneTerm((Analyzer)a, (String)"llengua", (String)"llengu");
        a.close();
    }

    public void testRandomStrings() throws Exception {
        CatalanAnalyzer a = new CatalanAnalyzer();
        TestCatalanAnalyzer.checkRandomData((Random)TestCatalanAnalyzer.random(), (Analyzer)a, (int)(1000 * RANDOM_MULTIPLIER));
        a.close();
    }
}

