/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.charfilter;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestHTMLStripCharFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testNothingChanged() throws Exception {
        String text = "this is only a test.";
        Reader cs = this.charFilterFactory("HTMLStrip", "escapedTags", "a, Title").create((Reader)new StringReader("this is only a test."));
        MockTokenizer ts = TestHTMLStripCharFilterFactory.whitespaceMockTokenizer((Reader)cs);
        TestHTMLStripCharFilterFactory.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"this", "is", "only", "a", "test."}, (int[])new int[]{0, 5, 8, 13, 15}, (int[])new int[]{4, 7, 12, 14, 20});
    }

    public void testNoEscapedTags() throws Exception {
        String text = "<u>this</u> is <b>only</b> a <I>test</I>.";
        Reader cs = this.charFilterFactory("HTMLStrip", new String[0]).create((Reader)new StringReader("<u>this</u> is <b>only</b> a <I>test</I>."));
        MockTokenizer ts = TestHTMLStripCharFilterFactory.whitespaceMockTokenizer((Reader)cs);
        TestHTMLStripCharFilterFactory.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"this", "is", "only", "a", "test."}, (int[])new int[]{3, 12, 18, 27, 32}, (int[])new int[]{11, 14, 26, 28, 41});
    }

    public void testEscapedTags() throws Exception {
        String text = "<u>this</u> is <b>only</b> a <I>test</I>.";
        Reader cs = this.charFilterFactory("HTMLStrip", "escapedTags", "U i").create((Reader)new StringReader("<u>this</u> is <b>only</b> a <I>test</I>."));
        MockTokenizer ts = TestHTMLStripCharFilterFactory.whitespaceMockTokenizer((Reader)cs);
        TestHTMLStripCharFilterFactory.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"<u>this</u>", "is", "only", "a", "<I>test</I>."}, (int[])new int[]{0, 12, 18, 27, 29}, (int[])new int[]{11, 14, 26, 28, 41});
    }

    public void testSeparatorOnlyEscapedTags() throws Exception {
        String text = "<u>this</u> is <b>only</b> a <I>test</I>.";
        Reader cs = this.charFilterFactory("HTMLStrip", "escapedTags", ",, , ").create((Reader)new StringReader("<u>this</u> is <b>only</b> a <I>test</I>."));
        MockTokenizer ts = TestHTMLStripCharFilterFactory.whitespaceMockTokenizer((Reader)cs);
        TestHTMLStripCharFilterFactory.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"this", "is", "only", "a", "test."}, (int[])new int[]{3, 12, 18, 27, 32}, (int[])new int[]{11, 14, 26, 28, 41});
    }

    public void testEmptyEscapedTags() throws Exception {
        String text = "<u>this</u> is <b>only</b> a <I>test</I>.";
        Reader cs = this.charFilterFactory("HTMLStrip", "escapedTags", "").create((Reader)new StringReader("<u>this</u> is <b>only</b> a <I>test</I>."));
        MockTokenizer ts = TestHTMLStripCharFilterFactory.whitespaceMockTokenizer((Reader)cs);
        TestHTMLStripCharFilterFactory.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"this", "is", "only", "a", "test."}, (int[])new int[]{3, 12, 18, 27, 32}, (int[])new int[]{11, 14, 26, 28, 41});
    }

    public void testSingleEscapedTag() throws Exception {
        String text = "<u>this</u> is <b>only</b> a <I>test</I>.";
        Reader cs = this.charFilterFactory("HTMLStrip", "escapedTags", ", B\r\n\t").create((Reader)new StringReader("<u>this</u> is <b>only</b> a <I>test</I>."));
        MockTokenizer ts = TestHTMLStripCharFilterFactory.whitespaceMockTokenizer((Reader)cs);
        TestHTMLStripCharFilterFactory.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"this", "is", "<b>only</b>", "a", "test."}, (int[])new int[]{3, 12, 15, 27, 32}, (int[])new int[]{11, 14, 26, 28, 41});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestHTMLStripCharFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.charFilterFactory("HTMLStrip", "bogusArg", "bogusValue"));
        TestHTMLStripCharFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

