/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.charfilter;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.charfilter.MappingCharFilter;
import org.apache.lucene.analysis.charfilter.NormalizeCharMap;
import org.apache.lucene.util.TestUtil;
import org.apache.lucene.util.UnicodeUtil;

public class TestMappingCharFilter
extends BaseTokenStreamTestCase {
    NormalizeCharMap normMap;

    public void setUp() throws Exception {
        super.setUp();
        NormalizeCharMap.Builder builder = new NormalizeCharMap.Builder();
        builder.add("aa", "a");
        builder.add("bbb", "b");
        builder.add("cccc", "cc");
        builder.add("h", "i");
        builder.add("j", "jj");
        builder.add("k", "kkk");
        builder.add("ll", "llll");
        builder.add("empty", "");
        builder.add(UnicodeUtil.newString((int[])new int[]{119074}, (int)0, (int)1), "fclef");
        builder.add("\uff01", "full-width-exclamation");
        this.normMap = builder.build();
    }

    public void testReaderReset() throws Exception {
        MappingCharFilter cs = new MappingCharFilter(this.normMap, (Reader)new StringReader("x"));
        char[] buf = new char[10];
        int len = cs.read(buf, 0, 10);
        TestMappingCharFilter.assertEquals((long)1L, (long)len);
        TestMappingCharFilter.assertEquals((long)120L, (long)buf[0]);
        len = cs.read(buf, 0, 10);
        TestMappingCharFilter.assertEquals((long)-1L, (long)len);
        cs.reset();
        len = cs.read(buf, 0, 10);
        TestMappingCharFilter.assertEquals((long)1L, (long)len);
        TestMappingCharFilter.assertEquals((long)120L, (long)buf[0]);
    }

    public void testNothingChange() throws Exception {
        MappingCharFilter cs = new MappingCharFilter(this.normMap, (Reader)new StringReader("x"));
        MockTokenizer ts = TestMappingCharFilter.whitespaceMockTokenizer((Reader)cs);
        TestMappingCharFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"x"}, (int[])new int[]{0}, (int[])new int[]{1}, (Integer)1);
    }

    public void test1to1() throws Exception {
        MappingCharFilter cs = new MappingCharFilter(this.normMap, (Reader)new StringReader("h"));
        MockTokenizer ts = TestMappingCharFilter.whitespaceMockTokenizer((Reader)cs);
        TestMappingCharFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"i"}, (int[])new int[]{0}, (int[])new int[]{1}, (Integer)1);
    }

    public void test1to2() throws Exception {
        MappingCharFilter cs = new MappingCharFilter(this.normMap, (Reader)new StringReader("j"));
        MockTokenizer ts = TestMappingCharFilter.whitespaceMockTokenizer((Reader)cs);
        TestMappingCharFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"jj"}, (int[])new int[]{0}, (int[])new int[]{1}, (Integer)1);
    }

    public void test1to3() throws Exception {
        MappingCharFilter cs = new MappingCharFilter(this.normMap, (Reader)new StringReader("k"));
        MockTokenizer ts = TestMappingCharFilter.whitespaceMockTokenizer((Reader)cs);
        TestMappingCharFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"kkk"}, (int[])new int[]{0}, (int[])new int[]{1}, (Integer)1);
    }

    public void test2to4() throws Exception {
        MappingCharFilter cs = new MappingCharFilter(this.normMap, (Reader)new StringReader("ll"));
        MockTokenizer ts = TestMappingCharFilter.whitespaceMockTokenizer((Reader)cs);
        TestMappingCharFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"llll"}, (int[])new int[]{0}, (int[])new int[]{2}, (Integer)2);
    }

    public void test2to1() throws Exception {
        MappingCharFilter cs = new MappingCharFilter(this.normMap, (Reader)new StringReader("aa"));
        MockTokenizer ts = TestMappingCharFilter.whitespaceMockTokenizer((Reader)cs);
        TestMappingCharFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"a"}, (int[])new int[]{0}, (int[])new int[]{2}, (Integer)2);
    }

    public void test3to1() throws Exception {
        MappingCharFilter cs = new MappingCharFilter(this.normMap, (Reader)new StringReader("bbb"));
        MockTokenizer ts = TestMappingCharFilter.whitespaceMockTokenizer((Reader)cs);
        TestMappingCharFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"b"}, (int[])new int[]{0}, (int[])new int[]{3}, (Integer)3);
    }

    public void test4to2() throws Exception {
        MappingCharFilter cs = new MappingCharFilter(this.normMap, (Reader)new StringReader("cccc"));
        MockTokenizer ts = TestMappingCharFilter.whitespaceMockTokenizer((Reader)cs);
        TestMappingCharFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"cc"}, (int[])new int[]{0}, (int[])new int[]{4}, (Integer)4);
    }

    public void test5to0() throws Exception {
        MappingCharFilter cs = new MappingCharFilter(this.normMap, (Reader)new StringReader("empty"));
        MockTokenizer ts = TestMappingCharFilter.whitespaceMockTokenizer((Reader)cs);
        TestMappingCharFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[0], (int[])new int[0], (int[])new int[0], (Integer)5);
    }

    public void testNonBMPChar() throws Exception {
        MappingCharFilter cs = new MappingCharFilter(this.normMap, (Reader)new StringReader(UnicodeUtil.newString((int[])new int[]{119074}, (int)0, (int)1)));
        MockTokenizer ts = TestMappingCharFilter.whitespaceMockTokenizer((Reader)cs);
        TestMappingCharFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"fclef"}, (int[])new int[]{0}, (int[])new int[]{2}, (Integer)2);
    }

    public void testFullWidthChar() throws Exception {
        MappingCharFilter cs = new MappingCharFilter(this.normMap, (Reader)new StringReader("\uff01"));
        MockTokenizer ts = TestMappingCharFilter.whitespaceMockTokenizer((Reader)cs);
        TestMappingCharFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"full-width-exclamation"}, (int[])new int[]{0}, (int[])new int[]{1}, (Integer)1);
    }

    public void testTokenStream() throws Exception {
        String testString = "h i j k ll cccc bbb aa";
        MappingCharFilter cs = new MappingCharFilter(this.normMap, (Reader)new StringReader(testString));
        MockTokenizer ts = TestMappingCharFilter.whitespaceMockTokenizer((Reader)cs);
        TestMappingCharFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"i", "i", "jj", "kkk", "llll", "cc", "b", "a"}, (int[])new int[]{0, 2, 4, 6, 8, 11, 16, 20}, (int[])new int[]{1, 3, 5, 7, 10, 15, 19, 22}, (Integer)testString.length());
    }

    public void testChained() throws Exception {
        String testString = "aaaa ll h";
        MappingCharFilter cs = new MappingCharFilter(this.normMap, (Reader)new MappingCharFilter(this.normMap, (Reader)new StringReader(testString)));
        MockTokenizer ts = TestMappingCharFilter.whitespaceMockTokenizer((Reader)cs);
        TestMappingCharFilter.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"a", "llllllll", "i"}, (int[])new int[]{0, 5, 8}, (int[])new int[]{4, 7, 9}, (Integer)testString.length());
    }

    public void testRandom() throws Exception {
        Analyzer analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)tokenizer);
            }

            protected Reader initReader(String fieldName, Reader reader) {
                return new MappingCharFilter(TestMappingCharFilter.this.normMap, reader);
            }
        };
        int numRounds = RANDOM_MULTIPLIER * 10000;
        TestMappingCharFilter.checkRandomData((Random)TestMappingCharFilter.random(), (Analyzer)analyzer, (int)numRounds);
        analyzer.close();
    }

    public void testFinalOffsetSpecialCase() throws Exception {
        NormalizeCharMap.Builder builder = new NormalizeCharMap.Builder();
        builder.add("t", "");
        builder.add("tmakdbl", "c");
        final NormalizeCharMap map = builder.build();
        Analyzer analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)tokenizer);
            }

            protected Reader initReader(String fieldName, Reader reader) {
                return new MappingCharFilter(map, reader);
            }
        };
        String text = "gzw f quaxot";
        TestMappingCharFilter.checkAnalysisConsistency((Random)TestMappingCharFilter.random(), (Analyzer)analyzer, (boolean)false, (String)text);
        analyzer.close();
    }

    public void testRandomMaps() throws Exception {
        int numIterations = TestMappingCharFilter.atLeast((int)3);
        for (int i = 0; i < numIterations; ++i) {
            final NormalizeCharMap map = this.randomMap();
            Analyzer analyzer = new Analyzer(){

                protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                    MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                    return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)tokenizer);
                }

                protected Reader initReader(String fieldName, Reader reader) {
                    return new MappingCharFilter(map, reader);
                }
            };
            int numRounds = 100;
            TestMappingCharFilter.checkRandomData((Random)TestMappingCharFilter.random(), (Analyzer)analyzer, (int)numRounds);
            analyzer.close();
        }
    }

    private NormalizeCharMap randomMap() {
        Random random = TestMappingCharFilter.random();
        NormalizeCharMap.Builder builder = new NormalizeCharMap.Builder();
        HashSet<String> keys = new HashSet<String>();
        int num = random.nextInt(5);
        for (int i = 0; i < num; ++i) {
            String key = TestUtil.randomSimpleString((Random)random);
            if (keys.contains(key) || key.length() == 0) continue;
            String value = TestUtil.randomSimpleString((Random)random);
            builder.add(key, value);
            keys.add(key);
        }
        return builder.build();
    }

    /*
     * Unable to fully structure code
     */
    public void testRandomMaps2() throws Exception {
        random = TestMappingCharFilter.random();
        numIterations = TestMappingCharFilter.atLeast((int)3);
        for (iter = 0; iter < numIterations; ++iter) {
            if (TestMappingCharFilter.VERBOSE) {
                System.out.println("\nTEST iter=" + iter);
            }
            endLetter = (char)TestUtil.nextInt((Random)random, (int)98, (int)122);
            map = new HashMap<String, String>();
            builder = new NormalizeCharMap.Builder();
            numMappings = TestMappingCharFilter.atLeast((int)5);
            if (TestMappingCharFilter.VERBOSE) {
                System.out.println("  mappings:");
            }
            while (map.size() < numMappings) {
                key = TestUtil.randomSimpleStringRange((Random)random, (char)'a', (char)endLetter, (int)7);
                if (key.length() == 0 || map.containsKey(key)) continue;
                value = TestUtil.randomSimpleString((Random)random);
                map.put(key, value);
                builder.add(key, value);
                if (!TestMappingCharFilter.VERBOSE) continue;
                System.out.println("    " + key + " -> " + value);
            }
            charMap = builder.build();
            if (TestMappingCharFilter.VERBOSE) {
                System.out.println("  test random documents...");
            }
            for (iter2 = 0; iter2 < 100; ++iter2) {
                content = TestUtil.randomSimpleStringRange((Random)random, (char)'a', (char)endLetter, (int)TestMappingCharFilter.atLeast((int)1000));
                if (TestMappingCharFilter.VERBOSE) {
                    System.out.println("  content=" + content);
                }
                output = new StringBuilder();
                inputOffsets = new ArrayList<Integer>();
                cumDiff = 0;
                charIdx = 0;
                while (charIdx < content.length()) {
                    matchLen = -1;
                    matchRepl = null;
                    for (Map.Entry<K, V> ent : map.entrySet()) {
                        match = (String)ent.getKey();
                        if (charIdx + match.length() > content.length()) continue;
                        limit = charIdx + match.length();
                        matches = true;
                        for (charIdx2 = charIdx; charIdx2 < limit; ++charIdx2) {
                            if (match.charAt(charIdx2 - charIdx) == content.charAt(charIdx2)) continue;
                            matches = false;
                            break;
                        }
                        if (!matches) continue;
                        repl = (String)ent.getValue();
                        if (match.length() <= matchLen) continue;
                        matchLen = match.length();
                        matchRepl = repl;
                    }
                    if (matchLen != -1) {
                        if (TestMappingCharFilter.VERBOSE) {
                            System.out.println("    match=" + content.substring(charIdx, charIdx + matchLen) + " @ off=" + charIdx + " repl=" + matchRepl);
                        }
                        output.append(matchRepl);
                        minLen = Math.min(matchLen, matchRepl.length());
                        for (outIdx = 0; outIdx < minLen; ++outIdx) {
                            inputOffsets.add(output.length() - matchRepl.length() + outIdx + cumDiff);
                        }
                        cumDiff += matchLen - matchRepl.length();
                        charIdx += matchLen;
                        if (matchRepl.length() >= matchLen && matchRepl.length() > matchLen) {
                            for (outIdx = matchLen; outIdx < matchRepl.length(); ++outIdx) {
                                inputOffsets.add(output.length() + cumDiff - 1);
                            }
                        }
                        if (!TestMappingCharFilter.$assertionsDisabled && inputOffsets.size() != output.length()) {
                            throw new AssertionError((Object)("inputOffsets.size()=" + inputOffsets.size() + " vs output.length()=" + output.length()));
                        }
                        continue;
                    }
                    inputOffsets.add(output.length() + cumDiff);
                    output.append(content.charAt(charIdx));
                    ++charIdx;
                }
                expected = output.toString();
                if (TestMappingCharFilter.VERBOSE) {
                    System.out.print("    expected:");
                    for (charIdx2 = 0; charIdx2 < expected.length(); ++charIdx2) {
                        System.out.print(" " + expected.charAt(charIdx2) + "/" + inputOffsets.get(charIdx2));
                    }
                    System.out.println();
                }
                mapFilter = new MappingCharFilter(charMap, (Reader)new StringReader(content));
                actualBuilder = new StringBuilder();
                actualInputOffsets = new ArrayList<Integer>();
                block9: while (true) {
                    if (random.nextBoolean()) {
                        ch = mapFilter.read();
                        if (ch == -1) break;
                        actualBuilder.append((char)ch);
                    } else {
                        off = (buffer = new char[TestUtil.nextInt((Random)random, (int)1, (int)100)]).length == 1 ? 0 : random.nextInt(buffer.length - 1);
                        count = mapFilter.read(buffer, off, buffer.length - off);
                        if (count == -1) break;
                        actualBuilder.append(buffer, off, count);
                    }
                    if (random.nextInt(10) != 7) continue;
                    while (true) {
                        if (actualInputOffsets.size() < actualBuilder.length()) ** break;
                        continue block9;
                        actualInputOffsets.add(mapFilter.correctOffset(actualInputOffsets.size()));
                    }
                    break;
                }
                while (actualInputOffsets.size() < actualBuilder.length()) {
                    actualInputOffsets.add(mapFilter.correctOffset(actualInputOffsets.size()));
                }
                actual = actualBuilder.toString();
                TestMappingCharFilter.assertEquals((Object)expected, (Object)actual);
                TestMappingCharFilter.assertEquals(inputOffsets, actualInputOffsets);
            }
        }
    }
}

