/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.charfilter;

import org.apache.lucene.analysis.charfilter.MappingCharFilterFactory;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestMappingCharFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testParseString() throws Exception {
        MappingCharFilterFactory f = (MappingCharFilterFactory)this.charFilterFactory("Mapping", new String[0]);
        TestMappingCharFilterFactory.expectThrows(IllegalArgumentException.class, () -> f.parseString("\\"));
        TestMappingCharFilterFactory.assertEquals((String)"unexpected escaped characters", (Object)"\\\"\n\t\r\b\f", (Object)f.parseString("\\\\\\\"\\n\\t\\r\\b\\f"));
        TestMappingCharFilterFactory.assertEquals((String)"unexpected escaped characters", (Object)"A", (Object)f.parseString("\\u0041"));
        TestMappingCharFilterFactory.assertEquals((String)"unexpected escaped characters", (Object)"AB", (Object)f.parseString("\\u0041\\u0042"));
        TestMappingCharFilterFactory.expectThrows(IllegalArgumentException.class, () -> f.parseString("\\u000"));
        TestMappingCharFilterFactory.expectThrows(NumberFormatException.class, () -> f.parseString("\\u123x"));
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestMappingCharFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.charFilterFactory("Mapping", "bogusArg", "bogusValue"));
        TestMappingCharFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

