/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cjk;

import java.io.IOException;
import java.io.Reader;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.charfilter.MappingCharFilter;
import org.apache.lucene.analysis.charfilter.NormalizeCharMap;
import org.apache.lucene.analysis.cjk.CJKAnalyzer;
import org.apache.lucene.analysis.cjk.CJKBigramFilter;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;

public class TestCJKAnalyzer
extends BaseTokenStreamTestCase {
    private Analyzer analyzer;

    public void setUp() throws Exception {
        super.setUp();
        this.analyzer = new CJKAnalyzer();
    }

    public void tearDown() throws Exception {
        this.analyzer.close();
        super.tearDown();
    }

    public void testJa1() throws IOException {
        TestCJKAnalyzer.assertAnalyzesTo((Analyzer)this.analyzer, (String)"\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341", (String[])new String[]{"\u4e00\u4e8c", "\u4e8c\u4e09", "\u4e09\u56db", "\u56db\u4e94", "\u4e94\u516d", "\u516d\u4e03", "\u4e03\u516b", "\u516b\u4e5d", "\u4e5d\u5341"}, (int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8}, (int[])new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10}, (String[])new String[]{"<DOUBLE>", "<DOUBLE>", "<DOUBLE>", "<DOUBLE>", "<DOUBLE>", "<DOUBLE>", "<DOUBLE>", "<DOUBLE>", "<DOUBLE>"}, (int[])new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1});
    }

    public void testJa2() throws IOException {
        TestCJKAnalyzer.assertAnalyzesTo((Analyzer)this.analyzer, (String)"\u4e00 \u4e8c\u4e09\u56db \u4e94\u516d\u4e03\u516b\u4e5d \u5341", (String[])new String[]{"\u4e00", "\u4e8c\u4e09", "\u4e09\u56db", "\u4e94\u516d", "\u516d\u4e03", "\u4e03\u516b", "\u516b\u4e5d", "\u5341"}, (int[])new int[]{0, 2, 3, 6, 7, 8, 9, 12}, (int[])new int[]{1, 4, 5, 8, 9, 10, 11, 13}, (String[])new String[]{"<SINGLE>", "<DOUBLE>", "<DOUBLE>", "<DOUBLE>", "<DOUBLE>", "<DOUBLE>", "<DOUBLE>", "<SINGLE>"}, (int[])new int[]{1, 1, 1, 1, 1, 1, 1, 1});
    }

    public void testC() throws IOException {
        TestCJKAnalyzer.assertAnalyzesTo((Analyzer)this.analyzer, (String)"abc defgh ijklmn opqrstu vwxy z", (String[])new String[]{"abc", "defgh", "ijklmn", "opqrstu", "vwxy", "z"}, (int[])new int[]{0, 4, 10, 17, 25, 30}, (int[])new int[]{3, 9, 16, 24, 29, 31}, (String[])new String[]{"<ALPHANUM>", "<ALPHANUM>", "<ALPHANUM>", "<ALPHANUM>", "<ALPHANUM>", "<ALPHANUM>"}, (int[])new int[]{1, 1, 1, 1, 1, 1});
    }

    public void testFinalOffset() throws IOException {
        TestCJKAnalyzer.assertAnalyzesTo((Analyzer)this.analyzer, (String)"\u3042\u3044", (String[])new String[]{"\u3042\u3044"}, (int[])new int[]{0}, (int[])new int[]{2}, (String[])new String[]{"<DOUBLE>"}, (int[])new int[]{1});
        TestCJKAnalyzer.assertAnalyzesTo((Analyzer)this.analyzer, (String)"\u3042\u3044   ", (String[])new String[]{"\u3042\u3044"}, (int[])new int[]{0}, (int[])new int[]{2}, (String[])new String[]{"<DOUBLE>"}, (int[])new int[]{1});
        TestCJKAnalyzer.assertAnalyzesTo((Analyzer)this.analyzer, (String)"test", (String[])new String[]{"test"}, (int[])new int[]{0}, (int[])new int[]{4}, (String[])new String[]{"<ALPHANUM>"}, (int[])new int[]{1});
        TestCJKAnalyzer.assertAnalyzesTo((Analyzer)this.analyzer, (String)"test   ", (String[])new String[]{"test"}, (int[])new int[]{0}, (int[])new int[]{4}, (String[])new String[]{"<ALPHANUM>"}, (int[])new int[]{1});
        TestCJKAnalyzer.assertAnalyzesTo((Analyzer)this.analyzer, (String)"\u3042\u3044test", (String[])new String[]{"\u3042\u3044", "test"}, (int[])new int[]{0, 2}, (int[])new int[]{2, 6}, (String[])new String[]{"<DOUBLE>", "<ALPHANUM>"}, (int[])new int[]{1, 1});
        TestCJKAnalyzer.assertAnalyzesTo((Analyzer)this.analyzer, (String)"test\u3042\u3044    ", (String[])new String[]{"test", "\u3042\u3044"}, (int[])new int[]{0, 4}, (int[])new int[]{4, 6}, (String[])new String[]{"<ALPHANUM>", "<DOUBLE>"}, (int[])new int[]{1, 1});
    }

    public void testMix() throws IOException {
        TestCJKAnalyzer.assertAnalyzesTo((Analyzer)this.analyzer, (String)"\u3042\u3044\u3046\u3048\u304aabc\u304b\u304d\u304f\u3051\u3053", (String[])new String[]{"\u3042\u3044", "\u3044\u3046", "\u3046\u3048", "\u3048\u304a", "abc", "\u304b\u304d", "\u304d\u304f", "\u304f\u3051", "\u3051\u3053"}, (int[])new int[]{0, 1, 2, 3, 5, 8, 9, 10, 11}, (int[])new int[]{2, 3, 4, 5, 8, 10, 11, 12, 13}, (String[])new String[]{"<DOUBLE>", "<DOUBLE>", "<DOUBLE>", "<DOUBLE>", "<ALPHANUM>", "<DOUBLE>", "<DOUBLE>", "<DOUBLE>", "<DOUBLE>"}, (int[])new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1});
    }

    public void testMix2() throws IOException {
        TestCJKAnalyzer.assertAnalyzesTo((Analyzer)this.analyzer, (String)"\u3042\u3044\u3046\u3048\u304aab\u3093c\u304b\u304d\u304f\u3051 \u3053", (String[])new String[]{"\u3042\u3044", "\u3044\u3046", "\u3046\u3048", "\u3048\u304a", "ab", "\u3093", "c", "\u304b\u304d", "\u304d\u304f", "\u304f\u3051", "\u3053"}, (int[])new int[]{0, 1, 2, 3, 5, 7, 8, 9, 10, 11, 14}, (int[])new int[]{2, 3, 4, 5, 7, 8, 9, 11, 12, 13, 15}, (String[])new String[]{"<DOUBLE>", "<DOUBLE>", "<DOUBLE>", "<DOUBLE>", "<ALPHANUM>", "<SINGLE>", "<ALPHANUM>", "<DOUBLE>", "<DOUBLE>", "<DOUBLE>", "<SINGLE>"}, (int[])new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1});
    }

    public void testNonIdeographic() throws IOException {
        TestCJKAnalyzer.assertAnalyzesTo((Analyzer)this.analyzer, (String)"\u4e00 \u0631\u0648\u0628\u0631\u062a \u0645\u0648\u064a\u0631", (String[])new String[]{"\u4e00", "\u0631\u0648\u0628\u0631\u062a", "\u0645\u0648\u064a\u0631"}, (int[])new int[]{0, 2, 8}, (int[])new int[]{1, 7, 12}, (String[])new String[]{"<SINGLE>", "<ALPHANUM>", "<ALPHANUM>"}, (int[])new int[]{1, 1, 1});
    }

    public void testNonIdeographicNonLetter() throws IOException {
        TestCJKAnalyzer.assertAnalyzesTo((Analyzer)this.analyzer, (String)"\u4e00 \u0631\u064f\u0648\u0628\u0631\u062a \u0645\u0648\u064a\u0631", (String[])new String[]{"\u4e00", "\u0631\u064f\u0648\u0628\u0631\u062a", "\u0645\u0648\u064a\u0631"}, (int[])new int[]{0, 2, 9}, (int[])new int[]{1, 8, 13}, (String[])new String[]{"<SINGLE>", "<ALPHANUM>", "<ALPHANUM>"}, (int[])new int[]{1, 1, 1});
    }

    public void testSurrogates() throws IOException {
        TestCJKAnalyzer.assertAnalyzesTo((Analyzer)this.analyzer, (String)"\ud866\udf05\u8271\u935f\u41f9\u612f\u701b", (String[])new String[]{"\ud866\udf05\u8271", "\u8271\u935f", "\u935f\u41f9", "\u41f9\u612f", "\u612f\u701b"}, (int[])new int[]{0, 2, 3, 4, 5}, (int[])new int[]{3, 4, 5, 6, 7}, (String[])new String[]{"<DOUBLE>", "<DOUBLE>", "<DOUBLE>", "<DOUBLE>", "<DOUBLE>"}, (int[])new int[]{1, 1, 1, 1, 1});
    }

    public void testReusableTokenStream() throws IOException {
        TestCJKAnalyzer.assertAnalyzesTo((Analyzer)this.analyzer, (String)"\u3042\u3044\u3046\u3048\u304aabc\u304b\u304d\u304f\u3051\u3053", (String[])new String[]{"\u3042\u3044", "\u3044\u3046", "\u3046\u3048", "\u3048\u304a", "abc", "\u304b\u304d", "\u304d\u304f", "\u304f\u3051", "\u3051\u3053"}, (int[])new int[]{0, 1, 2, 3, 5, 8, 9, 10, 11}, (int[])new int[]{2, 3, 4, 5, 8, 10, 11, 12, 13}, (String[])new String[]{"<DOUBLE>", "<DOUBLE>", "<DOUBLE>", "<DOUBLE>", "<ALPHANUM>", "<DOUBLE>", "<DOUBLE>", "<DOUBLE>", "<DOUBLE>"}, (int[])new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1});
        TestCJKAnalyzer.assertAnalyzesTo((Analyzer)this.analyzer, (String)"\u3042\u3044\u3046\u3048\u304aab\u3093c\u304b\u304d\u304f\u3051 \u3053", (String[])new String[]{"\u3042\u3044", "\u3044\u3046", "\u3046\u3048", "\u3048\u304a", "ab", "\u3093", "c", "\u304b\u304d", "\u304d\u304f", "\u304f\u3051", "\u3053"}, (int[])new int[]{0, 1, 2, 3, 5, 7, 8, 9, 10, 11, 14}, (int[])new int[]{2, 3, 4, 5, 7, 8, 9, 11, 12, 13, 15}, (String[])new String[]{"<DOUBLE>", "<DOUBLE>", "<DOUBLE>", "<DOUBLE>", "<ALPHANUM>", "<SINGLE>", "<ALPHANUM>", "<DOUBLE>", "<DOUBLE>", "<DOUBLE>", "<SINGLE>"}, (int[])new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1});
    }

    public void testSingleChar() throws IOException {
        TestCJKAnalyzer.assertAnalyzesTo((Analyzer)this.analyzer, (String)"\u4e00", (String[])new String[]{"\u4e00"}, (int[])new int[]{0}, (int[])new int[]{1}, (String[])new String[]{"<SINGLE>"}, (int[])new int[]{1});
    }

    public void testTokenStream() throws IOException {
        TestCJKAnalyzer.assertAnalyzesTo((Analyzer)this.analyzer, (String)"\u4e00\u4e01\u4e02", (String[])new String[]{"\u4e00\u4e01", "\u4e01\u4e02"}, (int[])new int[]{0, 1}, (int[])new int[]{2, 3}, (String[])new String[]{"<DOUBLE>", "<DOUBLE>"}, (int[])new int[]{1, 1});
    }

    public void testChangedOffsets() throws IOException {
        NormalizeCharMap.Builder builder = new NormalizeCharMap.Builder();
        builder.add("a", "\u4e00\u4e8c");
        builder.add("b", "\u4e8c\u4e09");
        final NormalizeCharMap norm = builder.build();
        Analyzer analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                StandardTokenizer tokenizer = new StandardTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new CJKBigramFilter((TokenStream)tokenizer));
            }

            protected Reader initReader(String fieldName, Reader reader) {
                return new MappingCharFilter(norm, reader);
            }
        };
        TestCJKAnalyzer.assertAnalyzesTo((Analyzer)analyzer, (String)"ab", (String[])new String[]{"\u4e00\u4e8c", "\u4e8c\u4e8c", "\u4e8c\u4e09"}, (int[])new int[]{0, 0, 1}, (int[])new int[]{1, 1, 2});
        analyzer.close();
    }

    public void testSingleChar2() throws Exception {
        Analyzer analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                FakeStandardTokenizer filter = new FakeStandardTokenizer((TokenStream)tokenizer);
                filter = new StopFilter((TokenStream)filter, CharArraySet.EMPTY_SET);
                filter = new CJKBigramFilter((TokenStream)filter);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)filter);
            }
        };
        TestCJKAnalyzer.assertAnalyzesTo((Analyzer)analyzer, (String)"\u4e00", (String[])new String[]{"\u4e00"}, (int[])new int[]{0}, (int[])new int[]{1}, (String[])new String[]{"<SINGLE>"}, (int[])new int[]{1});
        analyzer.close();
    }

    public void testRandomStrings() throws Exception {
        CJKAnalyzer a = new CJKAnalyzer();
        TestCJKAnalyzer.checkRandomData((Random)TestCJKAnalyzer.random(), (Analyzer)a, (int)(1000 * RANDOM_MULTIPLIER));
        a.close();
    }

    public void testRandomHugeStrings() throws Exception {
        CJKAnalyzer a = new CJKAnalyzer();
        TestCJKAnalyzer.checkRandomData((Random)TestCJKAnalyzer.random(), (Analyzer)a, (int)(100 * RANDOM_MULTIPLIER), (int)8192);
        a.close();
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new CJKBigramFilter((TokenStream)tokenizer));
            }
        };
        TestCJKAnalyzer.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }

    private static class FakeStandardTokenizer
    extends TokenFilter {
        final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);

        public FakeStandardTokenizer(TokenStream input) {
            super(input);
        }

        public boolean incrementToken() throws IOException {
            if (this.input.incrementToken()) {
                this.typeAtt.setType(StandardTokenizer.TOKEN_TYPES[10]);
                return true;
            }
            return false;
        }
    }
}

