/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cjk;

import java.io.Closeable;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.cjk.CJKBigramFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.IOUtils;

public class TestCJKBigramFilter
extends BaseTokenStreamTestCase {
    Analyzer analyzer;
    Analyzer unibiAnalyzer;

    public void setUp() throws Exception {
        super.setUp();
        this.analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                StandardTokenizer t = new StandardTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)t, (TokenStream)new CJKBigramFilter((TokenStream)t));
            }
        };
        this.unibiAnalyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                StandardTokenizer t = new StandardTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)t, (TokenStream)new CJKBigramFilter((TokenStream)t, 255, true));
            }
        };
    }

    public void tearDown() throws Exception {
        IOUtils.close((Closeable[])new Closeable[]{this.analyzer, this.unibiAnalyzer});
        super.tearDown();
    }

    public void testHuge() throws Exception {
        TestCJKBigramFilter.assertAnalyzesTo((Analyzer)this.analyzer, (String)"\u591a\u304f\u306e\u5b66\u751f\u304c\u8a66\u9a13\u306b\u843d\u3061\u305f\u591a\u304f\u306e\u5b66\u751f\u304c\u8a66\u9a13\u306b\u843d\u3061\u305f\u591a\u304f\u306e\u5b66\u751f\u304c\u8a66\u9a13\u306b\u843d\u3061\u305f\u591a\u304f\u306e\u5b66\u751f\u304c\u8a66\u9a13\u306b\u843d\u3061\u305f\u591a\u304f\u306e\u5b66\u751f\u304c\u8a66\u9a13\u306b\u843d\u3061\u305f\u591a\u304f\u306e\u5b66\u751f\u304c\u8a66\u9a13\u306b\u843d\u3061\u305f\u591a\u304f\u306e\u5b66\u751f\u304c\u8a66\u9a13\u306b\u843d\u3061\u305f\u591a\u304f\u306e\u5b66\u751f\u304c\u8a66\u9a13\u306b\u843d\u3061\u305f\u591a\u304f\u306e\u5b66\u751f\u304c\u8a66\u9a13\u306b\u843d\u3061\u305f\u591a\u304f\u306e\u5b66\u751f\u304c\u8a66\u9a13\u306b\u843d\u3061\u305f\u591a\u304f\u306e\u5b66\u751f\u304c\u8a66\u9a13\u306b\u843d\u3061\u305f", (String[])new String[]{"\u591a\u304f", "\u304f\u306e", "\u306e\u5b66", "\u5b66\u751f", "\u751f\u304c", "\u304c\u8a66", "\u8a66\u9a13", "\u9a13\u306b", "\u306b\u843d", "\u843d\u3061", "\u3061\u305f", "\u305f\u591a", "\u591a\u304f", "\u304f\u306e", "\u306e\u5b66", "\u5b66\u751f", "\u751f\u304c", "\u304c\u8a66", "\u8a66\u9a13", "\u9a13\u306b", "\u306b\u843d", "\u843d\u3061", "\u3061\u305f", "\u305f\u591a", "\u591a\u304f", "\u304f\u306e", "\u306e\u5b66", "\u5b66\u751f", "\u751f\u304c", "\u304c\u8a66", "\u8a66\u9a13", "\u9a13\u306b", "\u306b\u843d", "\u843d\u3061", "\u3061\u305f", "\u305f\u591a", "\u591a\u304f", "\u304f\u306e", "\u306e\u5b66", "\u5b66\u751f", "\u751f\u304c", "\u304c\u8a66", "\u8a66\u9a13", "\u9a13\u306b", "\u306b\u843d", "\u843d\u3061", "\u3061\u305f", "\u305f\u591a", "\u591a\u304f", "\u304f\u306e", "\u306e\u5b66", "\u5b66\u751f", "\u751f\u304c", "\u304c\u8a66", "\u8a66\u9a13", "\u9a13\u306b", "\u306b\u843d", "\u843d\u3061", "\u3061\u305f", "\u305f\u591a", "\u591a\u304f", "\u304f\u306e", "\u306e\u5b66", "\u5b66\u751f", "\u751f\u304c", "\u304c\u8a66", "\u8a66\u9a13", "\u9a13\u306b", "\u306b\u843d", "\u843d\u3061", "\u3061\u305f", "\u305f\u591a", "\u591a\u304f", "\u304f\u306e", "\u306e\u5b66", "\u5b66\u751f", "\u751f\u304c", "\u304c\u8a66", "\u8a66\u9a13", "\u9a13\u306b", "\u306b\u843d", "\u843d\u3061", "\u3061\u305f", "\u305f\u591a", "\u591a\u304f", "\u304f\u306e", "\u306e\u5b66", "\u5b66\u751f", "\u751f\u304c", "\u304c\u8a66", "\u8a66\u9a13", "\u9a13\u306b", "\u306b\u843d", "\u843d\u3061", "\u3061\u305f", "\u305f\u591a", "\u591a\u304f", "\u304f\u306e", "\u306e\u5b66", "\u5b66\u751f", "\u751f\u304c", "\u304c\u8a66", "\u8a66\u9a13", "\u9a13\u306b", "\u306b\u843d", "\u843d\u3061", "\u3061\u305f", "\u305f\u591a", "\u591a\u304f", "\u304f\u306e", "\u306e\u5b66", "\u5b66\u751f", "\u751f\u304c", "\u304c\u8a66", "\u8a66\u9a13", "\u9a13\u306b", "\u306b\u843d", "\u843d\u3061", "\u3061\u305f", "\u305f\u591a", "\u591a\u304f", "\u304f\u306e", "\u306e\u5b66", "\u5b66\u751f", "\u751f\u304c", "\u304c\u8a66", "\u8a66\u9a13", "\u9a13\u306b", "\u306b\u843d", "\u843d\u3061", "\u3061\u305f"});
    }

    public void testHanOnly() throws Exception {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                StandardTokenizer t = new StandardTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)t, (TokenStream)new CJKBigramFilter((TokenStream)t, 1));
            }
        };
        TestCJKBigramFilter.assertAnalyzesTo((Analyzer)a, (String)"\u591a\u304f\u306e\u5b66\u751f\u304c\u8a66\u9a13\u306b\u843d\u3061\u305f\u3002", (String[])new String[]{"\u591a", "\u304f", "\u306e", "\u5b66\u751f", "\u304c", "\u8a66\u9a13", "\u306b", "\u843d", "\u3061", "\u305f"}, (int[])new int[]{0, 1, 2, 3, 5, 6, 8, 9, 10, 11}, (int[])new int[]{1, 2, 3, 5, 6, 8, 9, 10, 11, 12}, (String[])new String[]{"<SINGLE>", "<HIRAGANA>", "<HIRAGANA>", "<DOUBLE>", "<HIRAGANA>", "<DOUBLE>", "<HIRAGANA>", "<SINGLE>", "<HIRAGANA>", "<HIRAGANA>", "<SINGLE>"}, (int[])new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, (int[])new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1});
        a.close();
    }

    public void testAllScripts() throws Exception {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                StandardTokenizer t = new StandardTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)t, (TokenStream)new CJKBigramFilter((TokenStream)t, 255, false));
            }
        };
        TestCJKBigramFilter.assertAnalyzesTo((Analyzer)a, (String)"\u591a\u304f\u306e\u5b66\u751f\u304c\u8a66\u9a13\u306b\u843d\u3061\u305f\u3002", (String[])new String[]{"\u591a\u304f", "\u304f\u306e", "\u306e\u5b66", "\u5b66\u751f", "\u751f\u304c", "\u304c\u8a66", "\u8a66\u9a13", "\u9a13\u306b", "\u306b\u843d", "\u843d\u3061", "\u3061\u305f"});
        a.close();
    }

    public void testUnigramsAndBigramsAllScripts() throws Exception {
        TestCJKBigramFilter.assertAnalyzesTo((Analyzer)this.unibiAnalyzer, (String)"\u591a\u304f\u306e\u5b66\u751f\u304c\u8a66\u9a13\u306b\u843d\u3061\u305f\u3002", (String[])new String[]{"\u591a", "\u591a\u304f", "\u304f", "\u304f\u306e", "\u306e", "\u306e\u5b66", "\u5b66", "\u5b66\u751f", "\u751f", "\u751f\u304c", "\u304c", "\u304c\u8a66", "\u8a66", "\u8a66\u9a13", "\u9a13", "\u9a13\u306b", "\u306b", "\u306b\u843d", "\u843d", "\u843d\u3061", "\u3061", "\u3061\u305f", "\u305f"}, (int[])new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11}, (int[])new int[]{1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12}, (String[])new String[]{"<SINGLE>", "<DOUBLE>", "<SINGLE>", "<DOUBLE>", "<SINGLE>", "<DOUBLE>", "<SINGLE>", "<DOUBLE>", "<SINGLE>", "<DOUBLE>", "<SINGLE>", "<DOUBLE>", "<SINGLE>", "<DOUBLE>", "<SINGLE>", "<DOUBLE>", "<SINGLE>", "<DOUBLE>", "<SINGLE>", "<DOUBLE>", "<SINGLE>", "<DOUBLE>", "<SINGLE>"}, (int[])new int[]{1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1}, (int[])new int[]{1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1});
    }

    public void testUnigramsAndBigramsHanOnly() throws Exception {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                StandardTokenizer t = new StandardTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)t, (TokenStream)new CJKBigramFilter((TokenStream)t, 1, true));
            }
        };
        TestCJKBigramFilter.assertAnalyzesTo((Analyzer)a, (String)"\u591a\u304f\u306e\u5b66\u751f\u304c\u8a66\u9a13\u306b\u843d\u3061\u305f\u3002", (String[])new String[]{"\u591a", "\u304f", "\u306e", "\u5b66", "\u5b66\u751f", "\u751f", "\u304c", "\u8a66", "\u8a66\u9a13", "\u9a13", "\u306b", "\u843d", "\u3061", "\u305f"}, (int[])new int[]{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 10, 11}, (int[])new int[]{1, 2, 3, 4, 5, 5, 6, 7, 8, 8, 9, 10, 11, 12}, (String[])new String[]{"<SINGLE>", "<HIRAGANA>", "<HIRAGANA>", "<SINGLE>", "<DOUBLE>", "<SINGLE>", "<HIRAGANA>", "<SINGLE>", "<DOUBLE>", "<SINGLE>", "<HIRAGANA>", "<SINGLE>", "<HIRAGANA>", "<HIRAGANA>", "<SINGLE>"}, (int[])new int[]{1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1}, (int[])new int[]{1, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1});
        a.close();
    }

    public void testUnigramsAndBigramsHuge() throws Exception {
        TestCJKBigramFilter.assertAnalyzesTo((Analyzer)this.unibiAnalyzer, (String)"\u591a\u304f\u306e\u5b66\u751f\u304c\u8a66\u9a13\u306b\u843d\u3061\u305f\u591a\u304f\u306e\u5b66\u751f\u304c\u8a66\u9a13\u306b\u843d\u3061\u305f\u591a\u304f\u306e\u5b66\u751f\u304c\u8a66\u9a13\u306b\u843d\u3061\u305f\u591a\u304f\u306e\u5b66\u751f\u304c\u8a66\u9a13\u306b\u843d\u3061\u305f\u591a\u304f\u306e\u5b66\u751f\u304c\u8a66\u9a13\u306b\u843d\u3061\u305f\u591a\u304f\u306e\u5b66\u751f\u304c\u8a66\u9a13\u306b\u843d\u3061\u305f\u591a\u304f\u306e\u5b66\u751f\u304c\u8a66\u9a13\u306b\u843d\u3061\u305f\u591a\u304f\u306e\u5b66\u751f\u304c\u8a66\u9a13\u306b\u843d\u3061\u305f\u591a\u304f\u306e\u5b66\u751f\u304c\u8a66\u9a13\u306b\u843d\u3061\u305f\u591a\u304f\u306e\u5b66\u751f\u304c\u8a66\u9a13\u306b\u843d\u3061\u305f\u591a\u304f\u306e\u5b66\u751f\u304c\u8a66\u9a13\u306b\u843d\u3061\u305f", (String[])new String[]{"\u591a", "\u591a\u304f", "\u304f", "\u304f\u306e", "\u306e", "\u306e\u5b66", "\u5b66", "\u5b66\u751f", "\u751f", "\u751f\u304c", "\u304c", "\u304c\u8a66", "\u8a66", "\u8a66\u9a13", "\u9a13", "\u9a13\u306b", "\u306b", "\u306b\u843d", "\u843d", "\u843d\u3061", "\u3061", "\u3061\u305f", "\u305f", "\u305f\u591a", "\u591a", "\u591a\u304f", "\u304f", "\u304f\u306e", "\u306e", "\u306e\u5b66", "\u5b66", "\u5b66\u751f", "\u751f", "\u751f\u304c", "\u304c", "\u304c\u8a66", "\u8a66", "\u8a66\u9a13", "\u9a13", "\u9a13\u306b", "\u306b", "\u306b\u843d", "\u843d", "\u843d\u3061", "\u3061", "\u3061\u305f", "\u305f", "\u305f\u591a", "\u591a", "\u591a\u304f", "\u304f", "\u304f\u306e", "\u306e", "\u306e\u5b66", "\u5b66", "\u5b66\u751f", "\u751f", "\u751f\u304c", "\u304c", "\u304c\u8a66", "\u8a66", "\u8a66\u9a13", "\u9a13", "\u9a13\u306b", "\u306b", "\u306b\u843d", "\u843d", "\u843d\u3061", "\u3061", "\u3061\u305f", "\u305f", "\u305f\u591a", "\u591a", "\u591a\u304f", "\u304f", "\u304f\u306e", "\u306e", "\u306e\u5b66", "\u5b66", "\u5b66\u751f", "\u751f", "\u751f\u304c", "\u304c", "\u304c\u8a66", "\u8a66", "\u8a66\u9a13", "\u9a13", "\u9a13\u306b", "\u306b", "\u306b\u843d", "\u843d", "\u843d\u3061", "\u3061", "\u3061\u305f", "\u305f", "\u305f\u591a", "\u591a", "\u591a\u304f", "\u304f", "\u304f\u306e", "\u306e", "\u306e\u5b66", "\u5b66", "\u5b66\u751f", "\u751f", "\u751f\u304c", "\u304c", "\u304c\u8a66", "\u8a66", "\u8a66\u9a13", "\u9a13", "\u9a13\u306b", "\u306b", "\u306b\u843d", "\u843d", "\u843d\u3061", "\u3061", "\u3061\u305f", "\u305f", "\u305f\u591a", "\u591a", "\u591a\u304f", "\u304f", "\u304f\u306e", "\u306e", "\u306e\u5b66", "\u5b66", "\u5b66\u751f", "\u751f", "\u751f\u304c", "\u304c", "\u304c\u8a66", "\u8a66", "\u8a66\u9a13", "\u9a13", "\u9a13\u306b", "\u306b", "\u306b\u843d", "\u843d", "\u843d\u3061", "\u3061", "\u3061\u305f", "\u305f", "\u305f\u591a", "\u591a", "\u591a\u304f", "\u304f", "\u304f\u306e", "\u306e", "\u306e\u5b66", "\u5b66", "\u5b66\u751f", "\u751f", "\u751f\u304c", "\u304c", "\u304c\u8a66", "\u8a66", "\u8a66\u9a13", "\u9a13", "\u9a13\u306b", "\u306b", "\u306b\u843d", "\u843d", "\u843d\u3061", "\u3061", "\u3061\u305f", "\u305f", "\u305f\u591a", "\u591a", "\u591a\u304f", "\u304f", "\u304f\u306e", "\u306e", "\u306e\u5b66", "\u5b66", "\u5b66\u751f", "\u751f", "\u751f\u304c", "\u304c", "\u304c\u8a66", "\u8a66", "\u8a66\u9a13", "\u9a13", "\u9a13\u306b", "\u306b", "\u306b\u843d", "\u843d", "\u843d\u3061", "\u3061", "\u3061\u305f", "\u305f", "\u305f\u591a", "\u591a", "\u591a\u304f", "\u304f", "\u304f\u306e", "\u306e", "\u306e\u5b66", "\u5b66", "\u5b66\u751f", "\u751f", "\u751f\u304c", "\u304c", "\u304c\u8a66", "\u8a66", "\u8a66\u9a13", "\u9a13", "\u9a13\u306b", "\u306b", "\u306b\u843d", "\u843d", "\u843d\u3061", "\u3061", "\u3061\u305f", "\u305f", "\u305f\u591a", "\u591a", "\u591a\u304f", "\u304f", "\u304f\u306e", "\u306e", "\u306e\u5b66", "\u5b66", "\u5b66\u751f", "\u751f", "\u751f\u304c", "\u304c", "\u304c\u8a66", "\u8a66", "\u8a66\u9a13", "\u9a13", "\u9a13\u306b", "\u306b", "\u306b\u843d", "\u843d", "\u843d\u3061", "\u3061", "\u3061\u305f", "\u305f", "\u305f\u591a", "\u591a", "\u591a\u304f", "\u304f", "\u304f\u306e", "\u306e", "\u306e\u5b66", "\u5b66", "\u5b66\u751f", "\u751f", "\u751f\u304c", "\u304c", "\u304c\u8a66", "\u8a66", "\u8a66\u9a13", "\u9a13", "\u9a13\u306b", "\u306b", "\u306b\u843d", "\u843d", "\u843d\u3061", "\u3061", "\u3061\u305f", "\u305f"});
    }

    public void testRandomUnibiStrings() throws Exception {
        TestCJKBigramFilter.checkRandomData((Random)TestCJKBigramFilter.random(), (Analyzer)this.unibiAnalyzer, (int)(1000 * RANDOM_MULTIPLIER));
    }

    public void testRandomUnibiHugeStrings() throws Exception {
        Random random = TestCJKBigramFilter.random();
        TestCJKBigramFilter.checkRandomData((Random)random, (Analyzer)this.unibiAnalyzer, (int)(100 * RANDOM_MULTIPLIER), (int)8192);
    }
}

