/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cjk;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestCJKBigramFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testDefaults() throws Exception {
        StringReader reader = new StringReader("\u591a\u304f\u306e\u5b66\u751f\u304c\u8a66\u9a13\u306b\u843d\u3061\u305f\u3002");
        Tokenizer stream = this.tokenizerFactory("standard", new String[0]).create();
        stream.setReader((Reader)reader);
        stream = this.tokenFilterFactory("CJKBigram", new String[0]).create((TokenStream)stream);
        TestCJKBigramFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"\u591a\u304f", "\u304f\u306e", "\u306e\u5b66", "\u5b66\u751f", "\u751f\u304c", "\u304c\u8a66", "\u8a66\u9a13", "\u9a13\u306b", "\u306b\u843d", "\u843d\u3061", "\u3061\u305f"});
    }

    public void testHanOnly() throws Exception {
        StringReader reader = new StringReader("\u591a\u304f\u306e\u5b66\u751f\u304c\u8a66\u9a13\u306b\u843d\u3061\u305f\u3002");
        Tokenizer stream = this.tokenizerFactory("standard", new String[0]).create();
        stream.setReader((Reader)reader);
        stream = this.tokenFilterFactory("CJKBigram", "hiragana", "false").create((TokenStream)stream);
        TestCJKBigramFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"\u591a", "\u304f", "\u306e", "\u5b66\u751f", "\u304c", "\u8a66\u9a13", "\u306b", "\u843d", "\u3061", "\u305f"});
    }

    public void testHanOnlyUnigrams() throws Exception {
        StringReader reader = new StringReader("\u591a\u304f\u306e\u5b66\u751f\u304c\u8a66\u9a13\u306b\u843d\u3061\u305f\u3002");
        Tokenizer stream = this.tokenizerFactory("standard", new String[0]).create();
        stream.setReader((Reader)reader);
        stream = this.tokenFilterFactory("CJKBigram", "hiragana", "false", "outputUnigrams", "true").create((TokenStream)stream);
        TestCJKBigramFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"\u591a", "\u304f", "\u306e", "\u5b66", "\u5b66\u751f", "\u751f", "\u304c", "\u8a66", "\u8a66\u9a13", "\u9a13", "\u306b", "\u843d", "\u3061", "\u305f"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestCJKBigramFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("CJKBigram", "bogusArg", "bogusValue"));
    }
}

