/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cjk;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.cjk.CJKWidthFilter;
import org.apache.lucene.analysis.core.KeywordTokenizer;

public class TestCJKWidthFilter
extends BaseTokenStreamTestCase {
    private Analyzer analyzer;

    public void setUp() throws Exception {
        super.setUp();
        this.analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer source = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)new CJKWidthFilter((TokenStream)source));
            }
        };
    }

    public void tearDown() throws Exception {
        this.analyzer.close();
        super.tearDown();
    }

    public void testFullWidthASCII() throws IOException {
        TestCJKWidthFilter.assertAnalyzesTo((Analyzer)this.analyzer, (String)"\uff34\uff45\uff53\uff54 \uff11\uff12\uff13\uff14", (String[])new String[]{"Test", "1234"}, (int[])new int[]{0, 5}, (int[])new int[]{4, 9});
    }

    public void testHalfWidthKana() throws IOException {
        TestCJKWidthFilter.assertAnalyzesTo((Analyzer)this.analyzer, (String)"\uff76\uff80\uff76\uff85", (String[])new String[]{"\u30ab\u30bf\u30ab\u30ca"});
        TestCJKWidthFilter.assertAnalyzesTo((Analyzer)this.analyzer, (String)"\uff73\uff9e\uff68\uff6f\uff82", (String[])new String[]{"\u30f4\u30a3\u30c3\u30c4"});
        TestCJKWidthFilter.assertAnalyzesTo((Analyzer)this.analyzer, (String)"\uff8a\uff9f\uff85\uff7f\uff86\uff6f\uff78", (String[])new String[]{"\u30d1\u30ca\u30bd\u30cb\u30c3\u30af"});
    }

    public void testRandomData() throws IOException {
        TestCJKWidthFilter.checkRandomData((Random)TestCJKWidthFilter.random(), (Analyzer)this.analyzer, (int)(1000 * RANDOM_MULTIPLIER));
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new CJKWidthFilter((TokenStream)tokenizer));
            }
        };
        TestCJKWidthFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

