/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cjk;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestCJKWidthFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void test() throws Exception {
        StringReader reader = new StringReader("\uff34\uff45\uff53\uff54 \uff11\uff12\uff13\uff14");
        MockTokenizer stream = TestCJKWidthFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("CJKWidth", new String[0]).create((TokenStream)stream);
        TestCJKWidthFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"Test", "1234"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestCJKWidthFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("CJKWidth", "bogusArg", "bogusValue"));
        TestCJKWidthFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

