/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ckb;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.ckb.SoraniAnalyzer;
import org.apache.lucene.util.Version;

public class TestSoraniAnalyzer
extends BaseTokenStreamTestCase {
    public void testResourcesAvailable() {
        new SoraniAnalyzer().close();
    }

    public void testStopwords() throws IOException {
        SoraniAnalyzer a = new SoraniAnalyzer();
        TestSoraniAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0626\u06d5\u0645 \u067e\u06cc\u0627\u0648\u06d5", (String[])new String[]{"\u067e\u06cc\u0627\u0648"});
        a.close();
    }

    public void testCustomStopwords() throws IOException {
        SoraniAnalyzer a = new SoraniAnalyzer(CharArraySet.EMPTY_SET);
        TestSoraniAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u0626\u06d5\u0645 \u067e\u06cc\u0627\u0648\u06d5", (String[])new String[]{"\u0626\u06d5\u0645", "\u067e\u06cc\u0627\u0648"});
        a.close();
    }

    public void testReusableTokenStream() throws IOException {
        SoraniAnalyzer a = new SoraniAnalyzer();
        TestSoraniAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u067e\u06cc\u0627\u0648\u06d5", (String[])new String[]{"\u067e\u06cc\u0627\u0648"});
        TestSoraniAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u067e\u06cc\u0627\u0648", (String[])new String[]{"\u067e\u06cc\u0627\u0648"});
        a.close();
    }

    public void testWithStemExclusionSet() throws IOException {
        CharArraySet set = new CharArraySet(1, true);
        set.add("\u067e\u06cc\u0627\u0648\u06d5");
        SoraniAnalyzer a = new SoraniAnalyzer(CharArraySet.EMPTY_SET, set);
        TestSoraniAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"\u067e\u06cc\u0627\u0648\u06d5", (String[])new String[]{"\u067e\u06cc\u0627\u0648\u06d5"});
        a.close();
    }

    public void testDigits() throws Exception {
        SoraniAnalyzer a = new SoraniAnalyzer();
        TestSoraniAnalyzer.checkOneTerm((Analyzer)a, (String)"\u0661\u0662\u0663\u0664", (String)"1234");
        a.close();
    }

    @Deprecated
    public void testDigitsBackCompat() throws Exception {
        SoraniAnalyzer a = new SoraniAnalyzer();
        a.setVersion(Version.LUCENE_5_3_0);
        TestSoraniAnalyzer.checkOneTerm((Analyzer)a, (String)"\u0661\u0662\u0663\u0664", (String)"\u0661\u0662\u0663\u0664");
        a.close();
    }

    public void testRandomStrings() throws Exception {
        SoraniAnalyzer a = new SoraniAnalyzer();
        TestSoraniAnalyzer.checkRandomData((Random)TestSoraniAnalyzer.random(), (Analyzer)a, (int)(1000 * RANDOM_MULTIPLIER));
        a.close();
    }
}

