/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ckb;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ckb.SoraniNormalizationFilter;
import org.apache.lucene.analysis.core.KeywordTokenizer;

public class TestSoraniNormalizationFilter
extends BaseTokenStreamTestCase {
    Analyzer a;

    public void setUp() throws Exception {
        super.setUp();
        this.a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.KEYWORD, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new SoraniNormalizationFilter((TokenStream)tokenizer));
            }
        };
    }

    public void tearDown() throws Exception {
        this.a.close();
        super.tearDown();
    }

    public void testY() throws Exception {
        TestSoraniNormalizationFilter.checkOneTerm((Analyzer)this.a, (String)"\u064a", (String)"\u06cc");
        TestSoraniNormalizationFilter.checkOneTerm((Analyzer)this.a, (String)"\u0649", (String)"\u06cc");
        TestSoraniNormalizationFilter.checkOneTerm((Analyzer)this.a, (String)"\u06cc", (String)"\u06cc");
    }

    public void testK() throws Exception {
        TestSoraniNormalizationFilter.checkOneTerm((Analyzer)this.a, (String)"\u0643", (String)"\u06a9");
        TestSoraniNormalizationFilter.checkOneTerm((Analyzer)this.a, (String)"\u06a9", (String)"\u06a9");
    }

    public void testH() throws Exception {
        TestSoraniNormalizationFilter.checkOneTerm((Analyzer)this.a, (String)"\u0647\u200c", (String)"\u06d5");
        TestSoraniNormalizationFilter.checkOneTerm((Analyzer)this.a, (String)"\u0647\u200c\u06a9", (String)"\u06d5\u06a9");
        TestSoraniNormalizationFilter.checkOneTerm((Analyzer)this.a, (String)"\u06be", (String)"\u0647");
        TestSoraniNormalizationFilter.checkOneTerm((Analyzer)this.a, (String)"\u0629", (String)"\u06d5");
    }

    public void testFinalH() throws Exception {
        TestSoraniNormalizationFilter.checkOneTerm((Analyzer)this.a, (String)"\u0647\u0647\u0647", (String)"\u0647\u0647\u06d5");
    }

    public void testRR() throws Exception {
        TestSoraniNormalizationFilter.checkOneTerm((Analyzer)this.a, (String)"\u0692", (String)"\u0695");
    }

    public void testInitialRR() throws Exception {
        TestSoraniNormalizationFilter.checkOneTerm((Analyzer)this.a, (String)"\u0631\u0631\u0631", (String)"\u0695\u0631\u0631");
    }

    public void testRemove() throws Exception {
        TestSoraniNormalizationFilter.checkOneTerm((Analyzer)this.a, (String)"\u0640", (String)"");
        TestSoraniNormalizationFilter.checkOneTerm((Analyzer)this.a, (String)"\u064b", (String)"");
        TestSoraniNormalizationFilter.checkOneTerm((Analyzer)this.a, (String)"\u064c", (String)"");
        TestSoraniNormalizationFilter.checkOneTerm((Analyzer)this.a, (String)"\u064d", (String)"");
        TestSoraniNormalizationFilter.checkOneTerm((Analyzer)this.a, (String)"\u064e", (String)"");
        TestSoraniNormalizationFilter.checkOneTerm((Analyzer)this.a, (String)"\u064f", (String)"");
        TestSoraniNormalizationFilter.checkOneTerm((Analyzer)this.a, (String)"\u0650", (String)"");
        TestSoraniNormalizationFilter.checkOneTerm((Analyzer)this.a, (String)"\u0651", (String)"");
        TestSoraniNormalizationFilter.checkOneTerm((Analyzer)this.a, (String)"\u0652", (String)"");
        TestSoraniNormalizationFilter.checkOneTerm((Analyzer)this.a, (String)"\u200c", (String)"");
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new SoraniNormalizationFilter((TokenStream)tokenizer));
            }
        };
        TestSoraniNormalizationFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

