/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ckb;

import java.io.IOException;
import java.nio.file.Path;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.VocabularyAssert;
import org.apache.lucene.analysis.ckb.SoraniAnalyzer;
import org.apache.lucene.analysis.ckb.SoraniNormalizationFilter;
import org.apache.lucene.analysis.ckb.SoraniStemFilter;
import org.apache.lucene.analysis.core.KeywordTokenizer;

public class TestSoraniStemFilter
extends BaseTokenStreamTestCase {
    Analyzer a;

    public void setUp() throws Exception {
        super.setUp();
        this.a = new SoraniAnalyzer();
    }

    public void tearDown() throws Exception {
        this.a.close();
        super.tearDown();
    }

    public void testIndefiniteSingular() throws Exception {
        TestSoraniStemFilter.checkOneTerm((Analyzer)this.a, (String)"\u067e\u06cc\u0627\u0648\u06ce\u06a9", (String)"\u067e\u06cc\u0627\u0648");
        TestSoraniStemFilter.checkOneTerm((Analyzer)this.a, (String)"\u062f\u06d5\u0631\u06af\u0627\u06cc\u06d5\u06a9", (String)"\u062f\u06d5\u0631\u06af\u0627");
    }

    public void testDefiniteSingular() throws Exception {
        TestSoraniStemFilter.checkOneTerm((Analyzer)this.a, (String)"\u067e\u06cc\u0627\u0648\u06d5\u0643\u06d5", (String)"\u067e\u06cc\u0627\u0648");
        TestSoraniStemFilter.checkOneTerm((Analyzer)this.a, (String)"\u062f\u06d5\u0631\u06af\u0627\u0643\u06d5", (String)"\u062f\u06d5\u0631\u06af\u0627");
    }

    public void testDemonstrativeSingular() throws Exception {
        TestSoraniStemFilter.checkOneTerm((Analyzer)this.a, (String)"\u06a9\u062a\u0627\u0648\u06cc\u06d5", (String)"\u06a9\u062a\u0627\u0648\u06cc");
        TestSoraniStemFilter.checkOneTerm((Analyzer)this.a, (String)"\u062f\u06d5\u0631\u06af\u0627\u06cc\u06d5", (String)"\u062f\u06d5\u0631\u06af\u0627");
    }

    public void testIndefinitePlural() throws Exception {
        TestSoraniStemFilter.checkOneTerm((Analyzer)this.a, (String)"\u067e\u06cc\u0627\u0648\u0627\u0646", (String)"\u067e\u06cc\u0627\u0648");
        TestSoraniStemFilter.checkOneTerm((Analyzer)this.a, (String)"\u062f\u06d5\u0631\u06af\u0627\u06cc\u0627\u0646", (String)"\u062f\u06d5\u0631\u06af\u0627");
    }

    public void testDefinitePlural() throws Exception {
        TestSoraniStemFilter.checkOneTerm((Analyzer)this.a, (String)"\u067e\u06cc\u0627\u0648\u06d5\u06a9\u0627\u0646", (String)"\u067e\u06cc\u0627\u0648");
        TestSoraniStemFilter.checkOneTerm((Analyzer)this.a, (String)"\u062f\u06d5\u0631\u06af\u0627\u06a9\u0627\u0646", (String)"\u062f\u06d5\u0631\u06af\u0627");
    }

    public void testDemonstrativePlural() throws Exception {
        TestSoraniStemFilter.checkOneTerm((Analyzer)this.a, (String)"\u067e\u06cc\u0627\u0648\u0627\u0646\u06d5", (String)"\u067e\u06cc\u0627\u0648");
        TestSoraniStemFilter.checkOneTerm((Analyzer)this.a, (String)"\u062f\u06d5\u0631\u06af\u0627\u06cc\u0627\u0646\u06d5", (String)"\u062f\u06d5\u0631\u06af\u0627");
    }

    public void testEzafe() throws Exception {
        TestSoraniStemFilter.checkOneTerm((Analyzer)this.a, (String)"\u0647\u06c6\u062a\u06cc\u0644\u06cc", (String)"\u0647\u06c6\u062a\u06cc\u0644");
        TestSoraniStemFilter.checkOneTerm((Analyzer)this.a, (String)"\u0647\u06c6\u062a\u06cc\u0644\u06ce\u06a9\u06cc", (String)"\u0647\u06c6\u062a\u06cc\u0644");
        TestSoraniStemFilter.checkOneTerm((Analyzer)this.a, (String)"\u0647\u06c6\u062a\u06cc\u0644\u0627\u0646\u06cc", (String)"\u0647\u06c6\u062a\u06cc\u0644");
    }

    public void testPostpositions() throws Exception {
        TestSoraniStemFilter.checkOneTerm((Analyzer)this.a, (String)"\u062f\u0648\u0648\u0631\u06d5\u0648\u06d5", (String)"\u062f\u0648\u0648\u0631");
        TestSoraniStemFilter.checkOneTerm((Analyzer)this.a, (String)"\u0646\u06cc\u0648\u06d5\u0634\u06d5\u0648\u062f\u0627", (String)"\u0646\u06cc\u0648\u06d5\u0634\u06d5\u0648");
        TestSoraniStemFilter.checkOneTerm((Analyzer)this.a, (String)"\u0633\u06c6\u0631\u0627\u0646\u0627", (String)"\u0633\u06c6\u0631\u0627\u0646");
    }

    public void testPossessives() throws Exception {
        TestSoraniStemFilter.checkOneTerm((Analyzer)this.a, (String)"\u067e\u0627\u0631\u06d5\u0645\u0627\u0646", (String)"\u067e\u0627\u0631\u06d5");
        TestSoraniStemFilter.checkOneTerm((Analyzer)this.a, (String)"\u067e\u0627\u0631\u06d5\u062a\u0627\u0646", (String)"\u067e\u0627\u0631\u06d5");
        TestSoraniStemFilter.checkOneTerm((Analyzer)this.a, (String)"\u067e\u0627\u0631\u06d5\u06cc\u0627\u0646", (String)"\u067e\u0627\u0631\u06d5");
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new SoraniStemFilter((TokenStream)tokenizer));
            }
        };
        TestSoraniStemFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }

    public void testVocabulary() throws Exception {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, true);
                SoraniNormalizationFilter stream = new SoraniNormalizationFilter((TokenStream)tokenizer);
                stream = new SoraniStemFilter((TokenStream)stream);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)stream);
            }
        };
        VocabularyAssert.assertVocabulary((Analyzer)a, (Path)this.getDataPath("ckbtestdata.zip"), (String)"testdata.txt");
        a.close();
    }
}

