/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ckb;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestSoraniStemFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testStemming() throws Exception {
        StringReader reader = new StringReader("\u067e\u06cc\u0627\u0648\u06d5\u06a9\u0627\u0646");
        MockTokenizer stream = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        ((Tokenizer)stream).setReader((Reader)reader);
        stream = this.tokenFilterFactory("SoraniStem", new String[0]).create((TokenStream)stream);
        TestSoraniStemFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"\u067e\u06cc\u0627\u0648"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestSoraniStemFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("SoraniStem", "bogusArg", "bogusValue"));
        TestSoraniStemFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

