/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.commongrams;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.commongrams.CommonGramsFilter;
import org.apache.lucene.analysis.commongrams.CommonGramsQueryFilter;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public class CommonGramsFilterTest
extends BaseTokenStreamTestCase {
    private static final CharArraySet commonWords = new CharArraySet(Arrays.asList("s", "a", "b", "c", "d", "the", "of"), false);

    public void testReset() throws Exception {
        String input = "How the s a brown s cow d like A B thing?";
        WhitespaceTokenizer wt = new WhitespaceTokenizer();
        wt.setReader((Reader)new StringReader("How the s a brown s cow d like A B thing?"));
        CommonGramsFilter cgf = new CommonGramsFilter((TokenStream)wt, commonWords);
        CharTermAttribute term = (CharTermAttribute)cgf.addAttribute(CharTermAttribute.class);
        cgf.reset();
        CommonGramsFilterTest.assertTrue((boolean)cgf.incrementToken());
        CommonGramsFilterTest.assertEquals((Object)"How", (Object)term.toString());
        CommonGramsFilterTest.assertTrue((boolean)cgf.incrementToken());
        CommonGramsFilterTest.assertEquals((Object)"How_the", (Object)term.toString());
        CommonGramsFilterTest.assertTrue((boolean)cgf.incrementToken());
        CommonGramsFilterTest.assertEquals((Object)"the", (Object)term.toString());
        CommonGramsFilterTest.assertTrue((boolean)cgf.incrementToken());
        CommonGramsFilterTest.assertEquals((Object)"the_s", (Object)term.toString());
        cgf.close();
        wt.setReader((Reader)new StringReader("How the s a brown s cow d like A B thing?"));
        cgf.reset();
        CommonGramsFilterTest.assertTrue((boolean)cgf.incrementToken());
        CommonGramsFilterTest.assertEquals((Object)"How", (Object)term.toString());
    }

    public void testQueryReset() throws Exception {
        String input = "How the s a brown s cow d like A B thing?";
        WhitespaceTokenizer wt = new WhitespaceTokenizer();
        wt.setReader((Reader)new StringReader("How the s a brown s cow d like A B thing?"));
        CommonGramsFilter cgf = new CommonGramsFilter((TokenStream)wt, commonWords);
        CommonGramsQueryFilter nsf = new CommonGramsQueryFilter(cgf);
        CharTermAttribute term = (CharTermAttribute)wt.addAttribute(CharTermAttribute.class);
        nsf.reset();
        CommonGramsFilterTest.assertTrue((boolean)nsf.incrementToken());
        CommonGramsFilterTest.assertEquals((Object)"How_the", (Object)term.toString());
        CommonGramsFilterTest.assertTrue((boolean)nsf.incrementToken());
        CommonGramsFilterTest.assertEquals((Object)"the_s", (Object)term.toString());
        nsf.close();
        wt.setReader((Reader)new StringReader("How the s a brown s cow d like A B thing?"));
        nsf.reset();
        CommonGramsFilterTest.assertTrue((boolean)nsf.incrementToken());
        CommonGramsFilterTest.assertEquals((Object)"How_the", (Object)term.toString());
    }

    public void testCommonGramsQueryFilter() throws Exception {
        Analyzer a = new Analyzer(){

            public Analyzer.TokenStreamComponents createComponents(String field) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new CommonGramsQueryFilter(new CommonGramsFilter((TokenStream)tokenizer, commonWords)));
            }
        };
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"brown fox", (String[])new String[]{"brown", "fox"});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"the fox", (String[])new String[]{"the_fox"});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"fox of", (String[])new String[]{"fox_of"});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"of the", (String[])new String[]{"of_the"});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"the", (String[])new String[]{"the"});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"foo", (String[])new String[]{"foo"});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"n n n", (String[])new String[]{"n", "n", "n"});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"quick brown fox", (String[])new String[]{"quick", "brown", "fox"});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"n n s", (String[])new String[]{"n", "n_s"});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"quick brown the", (String[])new String[]{"quick", "brown_the"});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"n s n", (String[])new String[]{"n_s", "s_n"});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"quick the brown", (String[])new String[]{"quick_the", "the_brown"});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"n s s", (String[])new String[]{"n_s", "s_s"});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"fox of the", (String[])new String[]{"fox_of", "of_the"});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"s n n", (String[])new String[]{"s_n", "n", "n"});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"the quick brown", (String[])new String[]{"the_quick", "quick", "brown"});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"s n s", (String[])new String[]{"s_n", "n_s"});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"the fox of", (String[])new String[]{"the_fox", "fox_of"});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"s s n", (String[])new String[]{"s_s", "s_n"});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"of the fox", (String[])new String[]{"of_the", "the_fox"});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"s s s", (String[])new String[]{"s_s", "s_s"});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"of the of", (String[])new String[]{"of_the", "the_of"});
        a.close();
    }

    public void testCommonGramsFilter() throws Exception {
        Analyzer a = new Analyzer(){

            public Analyzer.TokenStreamComponents createComponents(String field) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new CommonGramsFilter((TokenStream)tokenizer, commonWords));
            }
        };
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"the", (String[])new String[]{"the"});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"foo", (String[])new String[]{"foo"});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"brown fox", (String[])new String[]{"brown", "fox"}, (int[])new int[]{1, 1});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"the fox", (String[])new String[]{"the", "the_fox", "fox"}, (int[])new int[]{1, 0, 1});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"fox of", (String[])new String[]{"fox", "fox_of", "of"}, (int[])new int[]{1, 0, 1});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"of the", (String[])new String[]{"of", "of_the", "the"}, (int[])new int[]{1, 0, 1});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"n n n", (String[])new String[]{"n", "n", "n"}, (int[])new int[]{1, 1, 1});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"quick brown fox", (String[])new String[]{"quick", "brown", "fox"}, (int[])new int[]{1, 1, 1});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"n n s", (String[])new String[]{"n", "n", "n_s", "s"}, (int[])new int[]{1, 1, 0, 1});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"quick brown the", (String[])new String[]{"quick", "brown", "brown_the", "the"}, (int[])new int[]{1, 1, 0, 1});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"n s n", (String[])new String[]{"n", "n_s", "s", "s_n", "n"}, (int[])new int[]{1, 0, 1, 0, 1});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"quick the fox", (String[])new String[]{"quick", "quick_the", "the", "the_fox", "fox"}, (int[])new int[]{1, 0, 1, 0, 1});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"n s s", (String[])new String[]{"n", "n_s", "s", "s_s", "s"}, (int[])new int[]{1, 0, 1, 0, 1});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"fox of the", (String[])new String[]{"fox", "fox_of", "of", "of_the", "the"}, (int[])new int[]{1, 0, 1, 0, 1});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"s n n", (String[])new String[]{"s", "s_n", "n", "n"}, (int[])new int[]{1, 0, 1, 1});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"the quick brown", (String[])new String[]{"the", "the_quick", "quick", "brown"}, (int[])new int[]{1, 0, 1, 1});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"s n s", (String[])new String[]{"s", "s_n", "n", "n_s", "s"}, (int[])new int[]{1, 0, 1, 0, 1});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"the fox of", (String[])new String[]{"the", "the_fox", "fox", "fox_of", "of"}, (int[])new int[]{1, 0, 1, 0, 1});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"s s n", (String[])new String[]{"s", "s_s", "s", "s_n", "n"}, (int[])new int[]{1, 0, 1, 0, 1});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"of the fox", (String[])new String[]{"of", "of_the", "the", "the_fox", "fox"}, (int[])new int[]{1, 0, 1, 0, 1});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"s s s", (String[])new String[]{"s", "s_s", "s", "s_s", "s"}, (int[])new int[]{1, 0, 1, 0, 1});
        CommonGramsFilterTest.assertAnalyzesTo((Analyzer)a, (String)"of the of", (String[])new String[]{"of", "of_the", "the", "the_of", "of"}, (int[])new int[]{1, 0, 1, 0, 1});
        a.close();
    }

    public void testCaseSensitive() throws Exception {
        String input = "How The s a brown s cow d like A B thing?";
        MockTokenizer wt = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        wt.setReader((Reader)new StringReader("How The s a brown s cow d like A B thing?"));
        CommonGramsFilter cgf = new CommonGramsFilter((TokenStream)wt, commonWords);
        CommonGramsFilterTest.assertTokenStreamContents((TokenStream)cgf, (String[])new String[]{"How", "The", "The_s", "s", "s_a", "a", "a_brown", "brown", "brown_s", "s", "s_cow", "cow", "cow_d", "d", "d_like", "like", "A", "B", "thing?"});
    }

    public void testLastWordisStopWord() throws Exception {
        String input = "dog the";
        MockTokenizer wt = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        wt.setReader((Reader)new StringReader("dog the"));
        CommonGramsFilter cgf = new CommonGramsFilter((TokenStream)wt, commonWords);
        CommonGramsQueryFilter nsf = new CommonGramsQueryFilter(cgf);
        CommonGramsFilterTest.assertTokenStreamContents((TokenStream)nsf, (String[])new String[]{"dog_the"});
    }

    public void testFirstWordisStopWord() throws Exception {
        String input = "the dog";
        MockTokenizer wt = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        wt.setReader((Reader)new StringReader("the dog"));
        CommonGramsFilter cgf = new CommonGramsFilter((TokenStream)wt, commonWords);
        CommonGramsQueryFilter nsf = new CommonGramsQueryFilter(cgf);
        CommonGramsFilterTest.assertTokenStreamContents((TokenStream)nsf, (String[])new String[]{"the_dog"});
    }

    public void testOneWordQueryStopWord() throws Exception {
        String input = "the";
        MockTokenizer wt = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        wt.setReader((Reader)new StringReader("the"));
        CommonGramsFilter cgf = new CommonGramsFilter((TokenStream)wt, commonWords);
        CommonGramsQueryFilter nsf = new CommonGramsQueryFilter(cgf);
        CommonGramsFilterTest.assertTokenStreamContents((TokenStream)nsf, (String[])new String[]{"the"});
    }

    public void testOneWordQuery() throws Exception {
        String input = "monster";
        MockTokenizer wt = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        wt.setReader((Reader)new StringReader("monster"));
        CommonGramsFilter cgf = new CommonGramsFilter((TokenStream)wt, commonWords);
        CommonGramsQueryFilter nsf = new CommonGramsQueryFilter(cgf);
        CommonGramsFilterTest.assertTokenStreamContents((TokenStream)nsf, (String[])new String[]{"monster"});
    }

    public void TestFirstAndLastStopWord() throws Exception {
        String input = "the of";
        MockTokenizer wt = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        wt.setReader((Reader)new StringReader("the of"));
        CommonGramsFilter cgf = new CommonGramsFilter((TokenStream)wt, commonWords);
        CommonGramsQueryFilter nsf = new CommonGramsQueryFilter(cgf);
        CommonGramsFilterTest.assertTokenStreamContents((TokenStream)nsf, (String[])new String[]{"the_of"});
    }

    public void testRandomStrings() throws Exception {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer t = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                CommonGramsFilter cgf = new CommonGramsFilter((TokenStream)t, commonWords);
                return new Analyzer.TokenStreamComponents((Tokenizer)t, (TokenStream)cgf);
            }
        };
        CommonGramsFilterTest.checkRandomData((Random)CommonGramsFilterTest.random(), (Analyzer)a, (int)(1000 * RANDOM_MULTIPLIER));
        a.close();
        Analyzer b = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer t = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                CommonGramsFilter cgf = new CommonGramsFilter((TokenStream)t, commonWords);
                return new Analyzer.TokenStreamComponents((Tokenizer)t, (TokenStream)new CommonGramsQueryFilter(cgf));
            }
        };
        CommonGramsFilterTest.checkRandomData((Random)CommonGramsFilterTest.random(), (Analyzer)b, (int)(1000 * RANDOM_MULTIPLIER));
        b.close();
    }
}

