/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.commongrams;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.commongrams.CommonGramsFilterFactory;
import org.apache.lucene.analysis.core.TestStopFilterFactory;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;
import org.apache.lucene.analysis.util.ClasspathResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.util.Version;

public class TestCommonGramsFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testInform() throws Exception {
        ClasspathResourceLoader loader = new ClasspathResourceLoader(TestStopFilterFactory.class);
        TestCommonGramsFilterFactory.assertTrue((String)"loader is null and it shouldn't be", (loader != null ? 1 : 0) != 0);
        CommonGramsFilterFactory factory = (CommonGramsFilterFactory)this.tokenFilterFactory("CommonGrams", Version.LATEST, (ResourceLoader)loader, "words", "stop-1.txt", "ignoreCase", "true");
        CharArraySet words = factory.getCommonWords();
        TestCommonGramsFilterFactory.assertTrue((String)"words is null and it shouldn't be", (words != null ? 1 : 0) != 0);
        TestCommonGramsFilterFactory.assertTrue((String)("words Size: " + words.size() + " is not: " + 2), (words.size() == 2 ? 1 : 0) != 0);
        TestCommonGramsFilterFactory.assertTrue((String)(factory.isIgnoreCase() + " does not equal: " + true), (factory.isIgnoreCase() ? 1 : 0) != 0);
        factory = (CommonGramsFilterFactory)this.tokenFilterFactory("CommonGrams", Version.LATEST, (ResourceLoader)loader, "words", "stop-1.txt, stop-2.txt", "ignoreCase", "true");
        words = factory.getCommonWords();
        TestCommonGramsFilterFactory.assertTrue((String)"words is null and it shouldn't be", (words != null ? 1 : 0) != 0);
        TestCommonGramsFilterFactory.assertTrue((String)("words Size: " + words.size() + " is not: " + 4), (words.size() == 4 ? 1 : 0) != 0);
        TestCommonGramsFilterFactory.assertTrue((String)(factory.isIgnoreCase() + " does not equal: " + true), (factory.isIgnoreCase() ? 1 : 0) != 0);
        factory = (CommonGramsFilterFactory)this.tokenFilterFactory("CommonGrams", Version.LATEST, (ResourceLoader)loader, "words", "stop-snowball.txt", "format", "snowball", "ignoreCase", "true");
        words = factory.getCommonWords();
        TestCommonGramsFilterFactory.assertEquals((long)8L, (long)words.size());
        TestCommonGramsFilterFactory.assertTrue((boolean)words.contains((CharSequence)"he"));
        TestCommonGramsFilterFactory.assertTrue((boolean)words.contains((CharSequence)"him"));
        TestCommonGramsFilterFactory.assertTrue((boolean)words.contains((CharSequence)"his"));
        TestCommonGramsFilterFactory.assertTrue((boolean)words.contains((CharSequence)"himself"));
        TestCommonGramsFilterFactory.assertTrue((boolean)words.contains((CharSequence)"she"));
        TestCommonGramsFilterFactory.assertTrue((boolean)words.contains((CharSequence)"her"));
        TestCommonGramsFilterFactory.assertTrue((boolean)words.contains((CharSequence)"hers"));
        TestCommonGramsFilterFactory.assertTrue((boolean)words.contains((CharSequence)"herself"));
    }

    public void testDefaults() throws Exception {
        CommonGramsFilterFactory factory = (CommonGramsFilterFactory)this.tokenFilterFactory("CommonGrams", new String[0]);
        CharArraySet words = factory.getCommonWords();
        TestCommonGramsFilterFactory.assertTrue((String)"words is null and it shouldn't be", (words != null ? 1 : 0) != 0);
        TestCommonGramsFilterFactory.assertTrue((boolean)words.contains((CharSequence)"the"));
        MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        tokenizer.setReader((Reader)new StringReader("testing the factory"));
        TokenFilter stream = factory.create((TokenStream)tokenizer);
        TestCommonGramsFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"testing", "testing_the", "the", "the_factory", "factory"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestCommonGramsFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("CommonGrams", "bogusArg", "bogusValue"));
        TestCommonGramsFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

