/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.commongrams;

import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.commongrams.CommonGramsQueryFilterFactory;
import org.apache.lucene.analysis.core.TestStopFilterFactory;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;
import org.apache.lucene.analysis.util.ClasspathResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.util.Version;

public class TestCommonGramsQueryFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testInform() throws Exception {
        ClasspathResourceLoader loader = new ClasspathResourceLoader(TestStopFilterFactory.class);
        TestCommonGramsQueryFilterFactory.assertTrue((String)"loader is null and it shouldn't be", (loader != null ? 1 : 0) != 0);
        CommonGramsQueryFilterFactory factory = (CommonGramsQueryFilterFactory)this.tokenFilterFactory("CommonGramsQuery", Version.LATEST, (ResourceLoader)loader, "words", "stop-1.txt", "ignoreCase", "true");
        CharArraySet words = factory.getCommonWords();
        TestCommonGramsQueryFilterFactory.assertTrue((String)"words is null and it shouldn't be", (words != null ? 1 : 0) != 0);
        TestCommonGramsQueryFilterFactory.assertTrue((String)("words Size: " + words.size() + " is not: " + 2), (words.size() == 2 ? 1 : 0) != 0);
        TestCommonGramsQueryFilterFactory.assertTrue((String)(factory.isIgnoreCase() + " does not equal: " + true), (factory.isIgnoreCase() ? 1 : 0) != 0);
        factory = (CommonGramsQueryFilterFactory)this.tokenFilterFactory("CommonGramsQuery", Version.LATEST, (ResourceLoader)loader, "words", "stop-1.txt, stop-2.txt", "ignoreCase", "true");
        words = factory.getCommonWords();
        TestCommonGramsQueryFilterFactory.assertTrue((String)"words is null and it shouldn't be", (words != null ? 1 : 0) != 0);
        TestCommonGramsQueryFilterFactory.assertTrue((String)("words Size: " + words.size() + " is not: " + 4), (words.size() == 4 ? 1 : 0) != 0);
        TestCommonGramsQueryFilterFactory.assertTrue((String)(factory.isIgnoreCase() + " does not equal: " + true), (factory.isIgnoreCase() ? 1 : 0) != 0);
        factory = (CommonGramsQueryFilterFactory)this.tokenFilterFactory("CommonGramsQuery", Version.LATEST, (ResourceLoader)loader, "words", "stop-snowball.txt", "format", "snowball", "ignoreCase", "true");
        words = factory.getCommonWords();
        TestCommonGramsQueryFilterFactory.assertEquals((long)8L, (long)words.size());
        TestCommonGramsQueryFilterFactory.assertTrue((boolean)words.contains((CharSequence)"he"));
        TestCommonGramsQueryFilterFactory.assertTrue((boolean)words.contains((CharSequence)"him"));
        TestCommonGramsQueryFilterFactory.assertTrue((boolean)words.contains((CharSequence)"his"));
        TestCommonGramsQueryFilterFactory.assertTrue((boolean)words.contains((CharSequence)"himself"));
        TestCommonGramsQueryFilterFactory.assertTrue((boolean)words.contains((CharSequence)"she"));
        TestCommonGramsQueryFilterFactory.assertTrue((boolean)words.contains((CharSequence)"her"));
        TestCommonGramsQueryFilterFactory.assertTrue((boolean)words.contains((CharSequence)"hers"));
        TestCommonGramsQueryFilterFactory.assertTrue((boolean)words.contains((CharSequence)"herself"));
    }

    public void testDefaults() throws Exception {
        CommonGramsQueryFilterFactory factory = (CommonGramsQueryFilterFactory)this.tokenFilterFactory("CommonGramsQuery", new String[0]);
        CharArraySet words = factory.getCommonWords();
        TestCommonGramsQueryFilterFactory.assertTrue((String)"words is null and it shouldn't be", (words != null ? 1 : 0) != 0);
        TestCommonGramsQueryFilterFactory.assertTrue((boolean)words.contains((CharSequence)"the"));
        MockTokenizer tokenizer = TestCommonGramsQueryFilterFactory.whitespaceMockTokenizer((String)"testing the factory");
        TokenFilter stream = factory.create((TokenStream)tokenizer);
        TestCommonGramsQueryFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"testing_the", "the_factory"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestCommonGramsQueryFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("CommonGramsQuery", "bogusArg", "bogusValue"));
        TestCommonGramsQueryFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }

    public void testCompleteGraph() throws Exception {
        CommonGramsQueryFilterFactory factory = (CommonGramsQueryFilterFactory)this.tokenFilterFactory("CommonGramsQuery", new String[0]);
        CharArraySet words = factory.getCommonWords();
        TestCommonGramsQueryFilterFactory.assertTrue((String)"words is null and it shouldn't be", (words != null ? 1 : 0) != 0);
        TestCommonGramsQueryFilterFactory.assertTrue((boolean)words.contains((CharSequence)"the"));
        MockTokenizer tokenizer = TestCommonGramsQueryFilterFactory.whitespaceMockTokenizer((String)"testing the factory works");
        TokenFilter stream = factory.create((TokenStream)tokenizer);
        TestCommonGramsQueryFilterFactory.assertGraphStrings((TokenStream)stream, (String[])new String[]{"testing_the the_factory factory works"});
    }
}

