/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.compound;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.charfilter.MappingCharFilter;
import org.apache.lucene.analysis.charfilter.NormalizeCharMap;
import org.apache.lucene.analysis.compound.DictionaryCompoundWordTokenFilter;
import org.apache.lucene.analysis.compound.HyphenationCompoundWordTokenFilter;
import org.apache.lucene.analysis.compound.hyphenation.HyphenationTree;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.util.Attribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;
import org.xml.sax.InputSource;

public class TestCompoundWordTokenFilter
extends BaseTokenStreamTestCase {
    private static CharArraySet makeDictionary(String ... dictionary) {
        return new CharArraySet(Arrays.asList(dictionary), true);
    }

    public void testHyphenationCompoundWordsDA() throws Exception {
        CharArraySet dict = TestCompoundWordTokenFilter.makeDictionary("l\u00e6se", "hest");
        InputSource is = new InputSource(((Object)((Object)this)).getClass().getResource("da_UTF8.xml").toExternalForm());
        HyphenationTree hyphenator = HyphenationCompoundWordTokenFilter.getHyphenationTree((InputSource)is);
        HyphenationCompoundWordTokenFilter tf = new HyphenationCompoundWordTokenFilter((TokenStream)TestCompoundWordTokenFilter.whitespaceMockTokenizer((String)"min veninde som er lidt af en l\u00e6sehest"), hyphenator, dict, 5, 2, 15, false);
        TestCompoundWordTokenFilter.assertTokenStreamContents((TokenStream)tf, (String[])new String[]{"min", "veninde", "som", "er", "lidt", "af", "en", "l\u00e6sehest", "l\u00e6se", "hest"}, (int[])new int[]{1, 1, 1, 1, 1, 1, 1, 1, 0, 0});
    }

    public void testHyphenationCompoundWordsDELongestMatch() throws Exception {
        CharArraySet dict = TestCompoundWordTokenFilter.makeDictionary("basketball", "basket", "ball", "kurv");
        InputSource is = new InputSource(((Object)((Object)this)).getClass().getResource("da_UTF8.xml").toExternalForm());
        HyphenationTree hyphenator = HyphenationCompoundWordTokenFilter.getHyphenationTree((InputSource)is);
        HyphenationCompoundWordTokenFilter tf = new HyphenationCompoundWordTokenFilter((TokenStream)TestCompoundWordTokenFilter.whitespaceMockTokenizer((String)"basketballkurv"), hyphenator, dict, 5, 2, 40, true);
        TestCompoundWordTokenFilter.assertTokenStreamContents((TokenStream)tf, (String[])new String[]{"basketballkurv", "basketball", "ball", "kurv"}, (int[])new int[]{1, 0, 0, 0});
    }

    public void testHyphenationOnly() throws Exception {
        InputSource is = new InputSource(((Object)((Object)this)).getClass().getResource("da_UTF8.xml").toExternalForm());
        HyphenationTree hyphenator = HyphenationCompoundWordTokenFilter.getHyphenationTree((InputSource)is);
        HyphenationCompoundWordTokenFilter tf = new HyphenationCompoundWordTokenFilter((TokenStream)TestCompoundWordTokenFilter.whitespaceMockTokenizer((String)"basketballkurv"), hyphenator, 5, 2, 4);
        TestCompoundWordTokenFilter.assertTokenStreamContents((TokenStream)tf, (String[])new String[]{"basketballkurv", "ba", "sket", "bal", "ball", "kurv"});
        tf = new HyphenationCompoundWordTokenFilter((TokenStream)TestCompoundWordTokenFilter.whitespaceMockTokenizer((String)"basketballkurv"), hyphenator, 5, 4, 6);
        TestCompoundWordTokenFilter.assertTokenStreamContents((TokenStream)tf, (String[])new String[]{"basketballkurv", "basket", "sket", "ball", "lkurv", "kurv"});
        tf = new HyphenationCompoundWordTokenFilter((TokenStream)TestCompoundWordTokenFilter.whitespaceMockTokenizer((String)"basketballkurv"), hyphenator, 5, 4, 10);
        TestCompoundWordTokenFilter.assertTokenStreamContents((TokenStream)tf, (String[])new String[]{"basketballkurv", "basket", "basketbal", "basketball", "sket", "sketbal", "sketball", "ball", "ballkurv", "lkurv", "kurv"});
    }

    public void testDumbCompoundWordsSE() throws Exception {
        CharArraySet dict = TestCompoundWordTokenFilter.makeDictionary("Bil", "D\u00f6rr", "Motor", "Tak", "Borr", "Slag", "Hammar", "Pelar", "Glas", "\u00d6gon", "Fodral", "Bas", "Fiol", "Makare", "Ges\u00e4ll", "Sko", "Vind", "Rute", "Torkare", "Blad");
        DictionaryCompoundWordTokenFilter tf = new DictionaryCompoundWordTokenFilter((TokenStream)TestCompoundWordTokenFilter.whitespaceMockTokenizer((String)"Bild\u00f6rr Bilmotor Biltak Slagborr Hammarborr Pelarborr Glas\u00f6gonfodral Basfiolsfodral Basfiolsfodralmakareges\u00e4ll Skomakare Vindrutetorkare Vindrutetorkarblad abba"), dict);
        TestCompoundWordTokenFilter.assertTokenStreamContents((TokenStream)tf, (String[])new String[]{"Bild\u00f6rr", "Bil", "d\u00f6rr", "Bilmotor", "Bil", "motor", "Biltak", "Bil", "tak", "Slagborr", "Slag", "borr", "Hammarborr", "Hammar", "borr", "Pelarborr", "Pelar", "borr", "Glas\u00f6gonfodral", "Glas", "\u00f6gon", "fodral", "Basfiolsfodral", "Bas", "fiol", "fodral", "Basfiolsfodralmakareges\u00e4ll", "Bas", "fiol", "fodral", "makare", "ges\u00e4ll", "Skomakare", "Sko", "makare", "Vindrutetorkare", "Vind", "rute", "torkare", "Vindrutetorkarblad", "Vind", "rute", "blad", "abba"}, (int[])new int[]{0, 0, 0, 8, 8, 8, 17, 17, 17, 24, 24, 24, 33, 33, 33, 44, 44, 44, 54, 54, 54, 54, 69, 69, 69, 69, 84, 84, 84, 84, 84, 84, 111, 111, 111, 121, 121, 121, 121, 137, 137, 137, 137, 156}, (int[])new int[]{7, 7, 7, 16, 16, 16, 23, 23, 23, 32, 32, 32, 43, 43, 43, 53, 53, 53, 68, 68, 68, 68, 83, 83, 83, 83, 110, 110, 110, 110, 110, 110, 120, 120, 120, 136, 136, 136, 136, 155, 155, 155, 155, 160}, (int[])new int[]{1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1});
    }

    public void testDumbCompoundWordsSELongestMatch() throws Exception {
        CharArraySet dict = TestCompoundWordTokenFilter.makeDictionary("Bil", "D\u00f6rr", "Motor", "Tak", "Borr", "Slag", "Hammar", "Pelar", "Glas", "\u00d6gon", "Fodral", "Bas", "Fiols", "Makare", "Ges\u00e4ll", "Sko", "Vind", "Rute", "Torkare", "Blad", "Fiolsfodral");
        DictionaryCompoundWordTokenFilter tf = new DictionaryCompoundWordTokenFilter((TokenStream)TestCompoundWordTokenFilter.whitespaceMockTokenizer((String)"Basfiolsfodralmakareges\u00e4ll"), dict, 5, 2, 15, true);
        TestCompoundWordTokenFilter.assertTokenStreamContents((TokenStream)tf, (String[])new String[]{"Basfiolsfodralmakareges\u00e4ll", "Bas", "fiolsfodral", "fodral", "makare", "ges\u00e4ll"}, (int[])new int[]{0, 0, 0, 0, 0, 0}, (int[])new int[]{26, 26, 26, 26, 26, 26}, (int[])new int[]{1, 0, 0, 0, 0, 0});
    }

    public void testTokenEndingWithWordComponentOfMinimumLength() throws Exception {
        CharArraySet dict = TestCompoundWordTokenFilter.makeDictionary("ab", "cd", "ef");
        MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        tokenizer.setReader((Reader)new StringReader("abcdef"));
        DictionaryCompoundWordTokenFilter tf = new DictionaryCompoundWordTokenFilter((TokenStream)tokenizer, dict, 5, 2, 15, false);
        TestCompoundWordTokenFilter.assertTokenStreamContents((TokenStream)tf, (String[])new String[]{"abcdef", "ab", "cd", "ef"}, (int[])new int[]{0, 0, 0, 0}, (int[])new int[]{6, 6, 6, 6}, (int[])new int[]{1, 0, 0, 0});
    }

    public void testWordComponentWithLessThanMinimumLength() throws Exception {
        CharArraySet dict = TestCompoundWordTokenFilter.makeDictionary("abc", "d", "efg");
        MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        tokenizer.setReader((Reader)new StringReader("abcdefg"));
        DictionaryCompoundWordTokenFilter tf = new DictionaryCompoundWordTokenFilter((TokenStream)tokenizer, dict, 5, 2, 15, false);
        TestCompoundWordTokenFilter.assertTokenStreamContents((TokenStream)tf, (String[])new String[]{"abcdefg", "abc", "efg"}, (int[])new int[]{0, 0, 0}, (int[])new int[]{7, 7, 7}, (int[])new int[]{1, 0, 0});
    }

    public void testReset() throws Exception {
        CharArraySet dict = TestCompoundWordTokenFilter.makeDictionary("Rind", "Fleisch", "Draht", "Schere", "Gesetz", "Aufgabe", "\u00dcberwachung");
        MockTokenizer wsTokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        wsTokenizer.setEnableChecks(false);
        wsTokenizer.setReader((Reader)new StringReader("Rindfleisch\u00fcberwachungsgesetz"));
        DictionaryCompoundWordTokenFilter tf = new DictionaryCompoundWordTokenFilter((TokenStream)wsTokenizer, dict, 5, 2, 15, false);
        CharTermAttribute termAtt = (CharTermAttribute)tf.getAttribute(CharTermAttribute.class);
        tf.reset();
        TestCompoundWordTokenFilter.assertTrue((boolean)tf.incrementToken());
        TestCompoundWordTokenFilter.assertEquals((Object)"Rindfleisch\u00fcberwachungsgesetz", (Object)termAtt.toString());
        TestCompoundWordTokenFilter.assertTrue((boolean)tf.incrementToken());
        TestCompoundWordTokenFilter.assertEquals((Object)"Rind", (Object)termAtt.toString());
        tf.end();
        tf.close();
        wsTokenizer.setReader((Reader)new StringReader("Rindfleisch\u00fcberwachungsgesetz"));
        tf.reset();
        TestCompoundWordTokenFilter.assertTrue((boolean)tf.incrementToken());
        TestCompoundWordTokenFilter.assertEquals((Object)"Rindfleisch\u00fcberwachungsgesetz", (Object)termAtt.toString());
    }

    public void testRetainMockAttribute() throws Exception {
        CharArraySet dict = TestCompoundWordTokenFilter.makeDictionary("abc", "d", "efg");
        MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        tokenizer.setReader((Reader)new StringReader("abcdefg"));
        MockRetainAttributeFilter stream = new MockRetainAttributeFilter((TokenStream)tokenizer);
        stream = new DictionaryCompoundWordTokenFilter((TokenStream)stream, dict, 5, 2, 15, false);
        MockRetainAttribute retAtt = (MockRetainAttribute)stream.addAttribute(MockRetainAttribute.class);
        stream.reset();
        while (stream.incrementToken()) {
            TestCompoundWordTokenFilter.assertTrue((String)"Custom attribute value was lost", (boolean)retAtt.getRetain());
        }
    }

    public void testInvalidOffsets() throws Exception {
        final CharArraySet dict = TestCompoundWordTokenFilter.makeDictionary("fall");
        NormalizeCharMap.Builder builder = new NormalizeCharMap.Builder();
        builder.add("\u00fc", "ue");
        final NormalizeCharMap normMap = builder.build();
        Analyzer analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                DictionaryCompoundWordTokenFilter filter = new DictionaryCompoundWordTokenFilter((TokenStream)tokenizer, dict);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)filter);
            }

            protected Reader initReader(String fieldName, Reader reader) {
                return new MappingCharFilter(normMap, reader);
            }
        };
        TestCompoundWordTokenFilter.assertAnalyzesTo((Analyzer)analyzer, (String)"bank\u00fcberfall", (String[])new String[]{"bankueberfall", "fall"}, (int[])new int[]{0, 0}, (int[])new int[]{12, 12});
        analyzer.close();
    }

    public void testRandomStrings() throws Exception {
        final CharArraySet dict = TestCompoundWordTokenFilter.makeDictionary("a", "e", "i", "o", "u", "y", "bc", "def");
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new DictionaryCompoundWordTokenFilter((TokenStream)tokenizer, dict));
            }
        };
        TestCompoundWordTokenFilter.checkRandomData((Random)TestCompoundWordTokenFilter.random(), (Analyzer)a, (int)(1000 * RANDOM_MULTIPLIER));
        a.close();
        InputSource is = new InputSource(((Object)((Object)this)).getClass().getResource("da_UTF8.xml").toExternalForm());
        final HyphenationTree hyphenator = HyphenationCompoundWordTokenFilter.getHyphenationTree((InputSource)is);
        Analyzer b = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                HyphenationCompoundWordTokenFilter filter = new HyphenationCompoundWordTokenFilter((TokenStream)tokenizer, hyphenator);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)filter);
            }
        };
        TestCompoundWordTokenFilter.checkRandomData((Random)TestCompoundWordTokenFilter.random(), (Analyzer)b, (int)(1000 * RANDOM_MULTIPLIER));
        b.close();
    }

    public void testEmptyTerm() throws Exception {
        final CharArraySet dict = TestCompoundWordTokenFilter.makeDictionary("a", "e", "i", "o", "u", "y", "bc", "def");
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new DictionaryCompoundWordTokenFilter((TokenStream)tokenizer, dict));
            }
        };
        TestCompoundWordTokenFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
        InputSource is = new InputSource(((Object)((Object)this)).getClass().getResource("da_UTF8.xml").toExternalForm());
        final HyphenationTree hyphenator = HyphenationCompoundWordTokenFilter.getHyphenationTree((InputSource)is);
        Analyzer b = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                HyphenationCompoundWordTokenFilter filter = new HyphenationCompoundWordTokenFilter((TokenStream)tokenizer, hyphenator);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)filter);
            }
        };
        TestCompoundWordTokenFilter.checkOneTerm((Analyzer)b, (String)"", (String)"");
        b.close();
    }

    private static class MockRetainAttributeFilter
    extends TokenFilter {
        MockRetainAttribute retainAtt = (MockRetainAttribute)this.addAttribute(MockRetainAttribute.class);

        MockRetainAttributeFilter(TokenStream input) {
            super(input);
        }

        public boolean incrementToken() throws IOException {
            if (this.input.incrementToken()) {
                this.retainAtt.setRetain(true);
                return true;
            }
            return false;
        }
    }

    public static final class MockRetainAttributeImpl
    extends AttributeImpl
    implements MockRetainAttribute {
        private boolean retain = false;

        public void clear() {
            this.retain = false;
        }

        @Override
        public boolean getRetain() {
            return this.retain;
        }

        @Override
        public void setRetain(boolean retain) {
            this.retain = retain;
        }

        public void copyTo(AttributeImpl target) {
            MockRetainAttribute t = (MockRetainAttribute)target;
            t.setRetain(this.retain);
        }

        public void reflectWith(AttributeReflector reflector) {
            reflector.reflect(MockRetainAttribute.class, "retain", (Object)this.retain);
        }
    }

    public static interface MockRetainAttribute
    extends Attribute {
        public void setRetain(boolean var1);

        public boolean getRetain();
    }
}

