/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.compound;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestDictionaryCompoundWordTokenFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testDecompounding() throws Exception {
        StringReader reader = new StringReader("I like to play softball");
        MockTokenizer stream = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        ((Tokenizer)stream).setReader((Reader)reader);
        stream = this.tokenFilterFactory("DictionaryCompoundWord", "dictionary", "compoundDictionary.txt").create((TokenStream)stream);
        TestDictionaryCompoundWordTokenFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"I", "like", "to", "play", "softball", "soft", "ball"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestDictionaryCompoundWordTokenFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("DictionaryCompoundWord", "dictionary", "compoundDictionary.txt", "bogusArg", "bogusValue"));
        TestDictionaryCompoundWordTokenFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

